<?php
/**
 * Schemas list
 *
 * @package WP_Review
 * @since 3.0.0
 */

return array(
	'none'                => array(
		'label' => __( 'None', 'wp-review' ),
	),
	'Article'             => array(
		'label'      => __( 'Article', 'wp-review' ),
		'deprecated' => true,
		'fields'     => array(
			array(
				'name'    => 'headline',
				'label'   => __( 'Article Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Short Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Article Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'author',
				'@type'   => 'Person',
			),
			array(
				'name'    => 'publisher',
				'label'   => __( 'Publisher - Orgnization', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'publisher',
				'@type'   => 'Organization',
			),
			array(
				'name'    => 'publisher_logo',
				'label'   => __( 'Publisher Logo', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
				'part_of' => 'publisher',
				'@type'   => 'Organization',
			),
		),
	),
	'Book'                => array(
		'label'  => __( 'Book', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Book Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Book Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Book Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Book Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'bookEdition',
				'label'   => __( 'Book Edition', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'bookFormat',
				'label'   => __( 'Book Format', 'wp-review' ),
				'type'    => 'select',
				'default' => '',
				'options' => array(
					''                => '---',
					'AudiobookFormat' => 'AudiobookFormat',
					'EBook'           => 'EBook',
					'Hardcover'       => 'Hardcover',
					'Paperback'       => 'Paperback',
				),
			),
			array(
				'name'    => 'publisher',
				'label'   => __( 'Publisher - Orgnization', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'publisher',
				'@type'   => 'Organization',
			),
			array(
				'name'        => 'publisher_logo',
				'label'       => __( 'Publisher Logo', 'wp-review' ),
				'type'        => 'image',
				'default'     => '',
				'part_of'     => 'publisher',
				'custom_name' => 'logo',
				'@type'       => 'Organization',
			),
			array(
				'name'    => 'datePublished',
				'label'   => __( 'Date published', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'illustrator',
				'label'   => __( 'Illustrator', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'isbn',
				'label'   => __( 'ISBN', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'numberOfPages',
				'label'   => __( 'Number Of Pages', 'wp-review' ),
				'type'    => 'number',
				'default' => '',
			),
		),
	),
	'Course'              => array(
		'label'      => __( 'Course', 'wp-review' ),
		'fields'     => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'        => 'provider',
				'label'       => __( 'Provider', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'provider',
				'custom_name' => 'name',
				'@type'       => 'Organization',
			),
			array(
				'name'        => 'provider_logo',
				'label'       => __( 'Provider Logo', 'wp-review' ),
				'type'        => 'image',
				'default'     => '',
				'part_of'     => 'provider',
				'custom_name' => 'logo',
				'@type'       => 'Organization',
			),
		),
	),
	'CreativeWorkSeason'  => array(
		'label'  => __( 'CreativeWorkSeason', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'startDate',
				'label'   => __( 'Start date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'endDate',
				'label'   => __( 'End date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'numberOfEpisodes',
				'label'   => __( 'Number of episodes', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'seasonNumber',
				'label'   => __( 'Season number', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'episode',
				'label'   => __( 'Episode', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'partOfSeries',
				'label'   => __( 'Part of series', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'productionCompany',
				'label'   => __( 'Production company', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'director',
				'label'     => __( 'Director(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one director per line', 'wp-review' ),
			),
			array(
				'name'      => 'actor',
				'label'     => __( 'Actor(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one actor per line', 'wp-review' ),
			),
		),
	),
	'CreativeWorkSeries'  => array(
		'label'  => __( 'CreativeWorkSeries', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'startDate',
				'label'   => __( 'Start date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'endDate',
				'label'   => __( 'End date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'issn',
				'label'   => __( 'International Standard Serial Number (ISSN)', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'Episode'             => array(
		'label'  => __( 'Episode', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'dateCreated',
				'label'   => __( 'Date published', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'episodeNumber',
				'label'   => __( 'Episode number', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'partOfSeason',
				'label'   => __( 'Part of season', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'partOfSeries',
				'label'   => __( 'Part of series', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'productionCompany',
				'label'   => __( 'Production company', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'director',
				'label'     => __( 'Director(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one director per line', 'wp-review' ),
			),
			array(
				'name'      => 'actor',
				'label'     => __( 'Actor(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one actor per line', 'wp-review' ),
			),
			array(
				'name'      => 'genre',
				'label'     => __( 'Genre', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one item per line', 'wp-review' ),
			),
		),
	),
	'Event'               => array(
		'label'  => __( 'Event', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Event Title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Event Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Event Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'startDate',
				'label'   => __( 'Start date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'endDate',
				'label'   => __( 'End date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'        => 'location_name',
				'label'       => __( 'Location name', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'location',
				'custom_name' => 'name',
				'@type'       => 'Place',
			),
			array(
				'name'    => 'address',
				'label'   => __( 'Address', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'location',
				'@type'   => 'Place',
			),
			array(
				'name'        => 'performer',
				'label'       => __( 'Performer', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'performer',
				'custom_name' => 'name',
				'@type'       => 'Organization',
			),
			array(
				'name'    => 'price',
				'label'   => __( 'Offer price', 'wp-review' ),
				'info'    => __( 'Fill "0.0" to show the free price', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'    => 'priceCurrency',
				'label'   => __( 'Currency', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'        => 'offer_url',
				'label'       => __( 'Offer URL', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'offers',
				'custom_name' => 'url',
				'@type'       => 'Offer',
			),
			array(
				'name'        => 'validFrom',
				'label'       => __( 'Offer valid from', 'wp-review' ),
				'type'        => 'date',
				'default'     => '',
				'part_of'     => 'offers',
				'@type'       => 'Offer',
			),
			array(
				'name'    => 'availability',
				'label'   => __( 'Availability', 'wp-review' ),
				'type'    => 'select',
				'default' => '',
				'options' => array(
					''                    => '---',
					'Discontinued'        => 'Discontinued',
					'InStock'             => 'In Stock',
					'InStoreOnly'         => 'In Store Only',
					'LimitedAvailability' => 'Limited',
					'OnlineOnly'          => 'Online Only',
					'OutOfStock'          => 'Out Of Stock',
					'PreOrder'            => 'Pre Order',
					'PreSale'             => 'Pre Sale',
					'SoldOut'             => 'Sold Out',
				),
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
		),
	),
	'Game'                => array(
		'label'  => __( 'Game', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Game title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Game description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Game Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'Hotel'       => array(
		'label'  => __( 'Hotel', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'priceRange',
				'label'   => __( 'Price range', 'wp-review' ),
				'type'    => 'text',
				'default' => '$10 - $30',
			),
			array(
				'name'    => 'paymentAccepted',
				'label'   => __( 'Payment accepted', 'wp-review' ),
				'type'    => 'text',
				'default' => 'Credit Card',
			),
			array(
				'name'    => 'currenciesAccepted',
				'label'   => __( 'Currencies accepted', 'wp-review' ),
				'type'    => 'text',
				'default' => 'USD',
			),
			array(
				'name'  => 'address',
				'label' => __( 'Address', 'wp-review' ),
				'type'  => 'text',
			),
			array(
				'name'  => 'telephone',
				'label' => __( 'Telephone', 'wp-review' ),
				'type'  => 'text',
			),
		),
	),
	'LocalBusiness'       => array(
		'label'  => __( 'LocalBusiness', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Business Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'priceRange',
				'label'   => __( 'Price range', 'wp-review' ),
				'type'    => 'text',
				'default' => '$10 - $30',
			),
			array(
				'name'    => 'paymentAccepted',
				'label'   => __( 'Payment accepted', 'wp-review' ),
				'type'    => 'text',
				'default' => 'Credit Card',
			),
			array(
				'name'    => 'currenciesAccepted',
				'label'   => __( 'Currencies accepted', 'wp-review' ),
				'type'    => 'text',
				'default' => 'USD',
			),
			array(
				'name'  => 'address',
				'label' => __( 'Address', 'wp-review' ),
				'type'  => 'text',
			),
			array(
				'name'  => 'telephone',
				'label' => __( 'Telephone', 'wp-review' ),
				'type'  => 'text',
			),
		),
	),
	/*'HowTo'                => array(
		'label'  => __( 'HowTo', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Game Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'totalTime',
				'label'   => __( 'Total time', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Format: 1H30M. H - Hours, M - Minutes', 'wp-review' ),
			),
			array(
				'name'        => 'estimated_cost',
				'label'       => __( 'Estimated cost', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'estimatedCost',
				'@type'       => 'MonetaryAmount',
				'custom_name' => 'value',
			),
			array(
				'name'        => 'currency',
				'label'       => __( 'Currency', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'estimatedCost',
				'@type'       => 'MonetaryAmount',
			),
			array(
				'name' => 'tool',
				'label' => __( 'Tools', 'wp-review' ),
				'type'  => 'textarea',
				'default' => '',
				'info'    => __( 'Place one tool per line', 'wp-review' ),
			),
			array(
				'name' => 'supply',
				'label' => __( 'Supplies', 'wp-review' ),
				'type'  => 'textarea',
				'default' => '',
				'info'    => __( 'Place one supply per line', 'wp-review' ),
			),
			array(
				'name' => 'step',
				'label' => __( 'Steps', 'wp-review' ),
				'type'  => 'how_to_step',
				'default' => '',
			),
		),
	),*/
	'Movie'               => array(
		'label'  => __( 'Movie', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Movie title', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Movie description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Movie Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'dateCreated',
				'label'   => __( 'Date published', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
			array(
				'name'    => 'countryOfOrigin',
				'label'   => __( 'Country', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'duration',
				'label'   => __( 'Duration', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'director',
				'label'     => __( 'Director(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one director per line', 'wp-review' ),
			),
			array(
				'name'      => 'actor',
				'label'     => __( 'Actor(s)', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one actor per line', 'wp-review' ),
			),
			array(
				'name'      => 'genre',
				'label'     => __( 'Genre', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one item per line', 'wp-review' ),
			),
		),
	),
	'MusicPlaylist'       => array(
		'label'  => __( 'MusicPlaylist', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'numTracks',
				'label'   => __( 'Number of tracks', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'genre',
				'label'     => __( 'Genre', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one item per line', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'MusicRecording'      => array(
		'label'  => __( 'MusicRecording', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Track name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'byArtist',
				'label'   => __( 'By Artist', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'duration',
				'label'   => __( 'Track Duration', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'inAlbum',
				'label'   => __( 'Album name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'inPlaylist',
				'label'   => __( 'Playlist name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'isrcCode',
				'label'   => __( 'International Standard Recording Code', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'recordingOf',
				'label'   => __( 'Recording of', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'genre',
				'label'     => __( 'Genre', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one item per line', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'Organization'        => array(
		'label'  => __( 'Organization', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
		),
	),
	'Painting'            => array(
		'label'      => __( 'Painting', 'wp-review' ),
		'deprecated' => true,
		'fields'     => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'      => 'genre',
				'label'     => __( 'Genre', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Add one item per line', 'wp-review' ),
			),
			array(
				'name'    => 'datePublished',
				'label'   => __( 'Date published', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
			),
		),
	),
	'Place'               => array(
		'label'      => __( 'Place', 'wp-review' ),
		'deprecated' => true,
		'fields'     => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Place Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Place Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Place Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
		),
	),
	'Product'             => array(
		'label'  => __( 'Product', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Product Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Product Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Product Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'brand',
				'label'   => __( 'Brand', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'sku',
				'label'   => __( 'SKU', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'mpn',
				'label'   => __( 'MPN', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'gtin8',
				'label'   => __( 'GTIN-8', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'price',
				'label'   => __( 'Offer price', 'wp-review' ),
				'info'    => __( 'Fill "0.0" to show the free price', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'    => 'priceCurrency',
				'label'   => __( 'Currency', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'    => 'availability',
				'label'   => __( 'Availability', 'wp-review' ),
				'type'    => 'select',
				'default' => '',
				'options' => array(
					''                    => '---',
					'Discontinued'        => 'Discontinued',
					'InStock'             => 'In Stock',
					'InStoreOnly'         => 'In Store Only',
					'LimitedAvailability' => 'Limited',
					'OnlineOnly'          => 'Online Only',
					'OutOfStock'          => 'Out Of Stock',
					'PreOrder'            => 'Pre Order',
					'PreSale'             => 'Pre Sale',
					'SoldOut'             => 'Sold Out',
				),
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'        => 'offer_url',
				'label'       => __( 'Offer URL', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'offers',
				'custom_name' => 'url',
				'@type'       => 'Offer',
			),
			array(
				'name'        => 'priceValidUntil',
				'label'       => __( 'Valid until', 'wp-review' ),
				'type'        => 'date',
				'default'     => '',
				'part_of'     => 'offers',
				'@type'       => 'Offer',
			),
		),
	),
	'Recipe'              => array(
		'label'  => __( 'Recipe', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Recipe Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'prepTime',
				'label'   => __( 'Preperation time', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Format: 1H30M. H - Hours, M - Minutes', 'wp-review' ),
			),
			array(
				'name'    => 'cookTime',
				'label'   => __( 'Cook Time', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Format: 1H30M. H - Hours, M - Minutes', 'wp-review' ),
			),
			array(
				'name'    => 'totalTime',
				'label'   => __( 'Total Time', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Format: 1H30M. H - Hours, M - Minutes', 'wp-review' ),
			),
			array(
				'name'    => 'recipeCategory',
				'label'   => __( 'Type', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Type of dish, for example "appetizer", "entree", or "dessert"', 'wp-review' ),
			),
			array(
				'name'    => 'recipeYield',
				'label'   => __( 'Recipe Yield', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Quantity produced by the recipe, for example "4 servings"', 'wp-review' ),
			),
			array(
				'name'      => 'recipeIngredient',
				'label'     => __( 'Recipe Ingredients', 'wp-review' ),
				'type'      => 'textarea',
				'multiline' => true,
				'default'   => '',
				'info'      => __( 'Recipe ingredients, add one item per line', 'wp-review' ),
			),
			array(
				'name'    => 'recipeInstructions',
				'label'   => __( 'Recipe Instructions', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
				'info'    => __( 'Steps to take', 'wp-review' ),
			),
			array(
				'name'    => 'recipeCuisine',
				'label'   => __( 'Recipe Cuisine', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'keywords',
				'label'   => __( 'Keywords', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'Separate by commas', 'wp-review' ),
			),
			array(
				'name'    => 'calories',
				'label'   => __( 'Calories', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'The number of calories', 'wp-review' ),
				'part_of' => 'nutrition',
				'@type'   => 'NutritionInformation',
			),
			array(
				'name'        => 'video_name',
				'custom_name' => 'name',
				'label'       => __( 'Video name', 'wp-review' ),
				'type'        => 'text',
				'default'     => '',
				'part_of'     => 'video',
				'@type'       => 'VideoObject',
			),
			array(
				'name'        => 'video_description',
				'custom_name' => 'description',
				'label'       => __( 'Video description', 'wp-review' ),
				'type'        => 'textarea',
				'default'     => '',
				'part_of'     => 'video',
				'@type'       => 'VideoObject',
			),
			array(
				'name'    => 'thumbnailUrl',
				'label'   => __( 'Video thumbnail URL', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
				'part_of' => 'video',
				'@type'   => 'VideoObject',
			),
			array(
				'name'    => 'uploadDate',
				'label'   => __( 'Video upload date', 'wp-review' ),
				'type'    => 'date',
				'default' => '',
				'part_of' => 'video',
				'@type'   => 'VideoObject',
			),
		),
	),
	'Restaurant'          => array(
		'label'  => __( 'Restaurant', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Restaurant Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Restaurant Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Restaurant Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'priceRange',
				'label'   => __( 'Price range', 'wp-review' ),
				'type'    => 'text',
				'default' => '$10 - $30',
			),
			array(
				'name'  => 'address',
				'label' => __( 'Address', 'wp-review' ),
				'type'  => 'text',
			),
			array(
				'name'  => 'servesCuisine',
				'label' => __( 'Cuisine', 'wp-review' ),
				'type'  => 'text',
			),
			array(
				'name'  => 'telephone',
				'label' => __( 'Telephone', 'wp-review' ),
				'type'  => 'text',
			),
		),
	),
	'SoftwareApplication' => array(
		'label'  => __( 'SoftwareApplication', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'price',
				'label'   => __( 'Offer price', 'wp-review' ),
				'info'    => __( 'Fill "0.0" to show the free price', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'    => 'priceCurrency',
				'label'   => __( 'Currency', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'part_of' => 'offers',
				'@type'   => 'Offer',
			),
			array(
				'name'    => 'operatingSystem',
				'label'   => __( 'Operating System', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'For example, "Windows 7", "OSX 10.6", "Android 1.6"', 'wp-review' ),
			),
			array(
				'name'    => 'applicationCategory',
				'label'   => __( 'Application Category', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
				'info'    => __( 'For example, "Game", "Multimedia"', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'Store'               => array(
		'label'  => __( 'Store', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Store Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Store Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Store Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'priceRange',
				'label'   => __( 'Price range', 'wp-review' ),
				'type'    => 'text',
				'default' => '$10 - $30',
			),
			array(
				'name'  => 'address',
				'label' => __( 'Address', 'wp-review' ),
				'type'  => 'text',
			),
			array(
				'name'  => 'telephone',
				'label' => __( 'Telephone', 'wp-review' ),
				'type'  => 'text',
			),
		),
	),
	'Thing'               => array(
		'label'      => __( 'Thing', 'wp-review' ),
		'deprecated' => true,
	),
	'TVSeries'            => array(
		'label'  => __( 'TVSeries', 'wp-review' ),
		'fields' => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
			array(
				'name'    => 'author',
				'label'   => __( 'Author', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
		),
	),
	'WebSite'             => array(
		'label'      => __( 'WebSite', 'wp-review' ),
		'deprecated' => true,
		'fields'     => array(
			array(
				'name'    => 'name',
				'label'   => __( 'Name', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'    => 'description',
				'label'   => __( 'Description', 'wp-review' ),
				'type'    => 'textarea',
				'default' => '',
			),
			array(
				'name'    => 'image',
				'label'   => __( 'Image', 'wp-review' ),
				'type'    => 'image',
				'default' => '',
			),
			array(
				'name'    => 'more_text',
				'label'   => __( 'More link text', 'wp-review' ),
				'type'    => 'text',
				'default' => __( '[ More ]', 'wp-review' ),
				'omit'    => true,
			),
			array(
				'name'    => 'url',
				'label'   => __( 'More link URL', 'wp-review' ),
				'type'    => 'text',
				'default' => '',
			),
			array(
				'name'      => 'use_button_style',
				'label'     => __( 'Use button style', 'wp-review' ),
				'type'      => 'switch',
				'default'   => false,
				'omit'      => true,
				'on_label'  => __( 'Button', 'wp-review' ),
				'off_label' => __( 'Link', 'wp-review' ),
			),
		),
	),
);
