<?php
/**
 * Plugin Name: Simple Author Box Pro
 * Description: Add a responsive, awesome looking author box with social icons on your posts.
 * Version: 5.13
 * Author: WebFactory Ltd
 * Author URI: https://www.webfactoryltd.com/
 * Requires: 4.6 or higher
 * License: Proprietary commercial license
 * Requires PHP: 5.6
 * Text Domain: simple-author-box
 * Copyright 2014-2021 WebFactory Ltd sab@webfactoryltd.com
 */


if (!function_exists('is_plugin_active')) {
  require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

if(is_plugin_active('simple-author-box-premium/simple-author-box.php')){
    deactivate_plugins('simple-author-box-premium');
    set_transient('sab_error_msg', '<div class="sab-alert sab-alert-info"><strong>The old Simple Author Box Premium version 2.3.20 has been automatically deactivated. You can safely delete it anytime you wish.</strong><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>', 30);
    $pointers = [];
    $sab_plugin_name = apply_filters('sab_plugin_name', __('Simple Author Box', 'simple-author-box'));
    $pointers['welcome'] = array('target' => '#menu-appearance', 'edge' => 'left', 'align' => 'right', 'content' => 'Thank you for installing the <b style="font-weight: 800; font-variant: small-caps;">' . $sab_plugin_name . '</b> plugin! Please open <a href="' . admin_url('themes.php?page=simple-author-box') . '">Appearance - ' . $sab_plugin_name . '</a> to configure your author box.');
    update_option('sab_pointers', $pointers);
} else {
    define('SIMPLE_AUTHOR_BOX_PATH', plugin_dir_path(__FILE__));
    define('SIMPLE_AUTHOR_BOX_ASSETS', plugins_url('/assets/', __FILE__));
    define('SIMPLE_AUTHOR_BOX_SLUG', plugin_basename(__FILE__));
    define('SIMPLE_AUTHOR_BOX_FILE', __FILE__);
    define('SIMPLE_AUTHOR_SCRIPT_DEBUG', false);
    define('SIMPLE_AUTHOR_POINTERS', 'sab_pointers');

    $plugin_data = get_file_data(__FILE__, array('version' => 'Version'), 'plugin');
    define('SIMPLE_AUTHOR_BOX_VERSION', $plugin_data['version']);
    require_once SIMPLE_AUTHOR_BOX_PATH . 'inc/class-simple-author-box.php';

    global $simple_author_box;
    $simple_author_box = Simple_Author_Box::get_instance();
    include "premium/simple-author-box-pro.php";
}
