<?php
define( 'SIMPLE_AUTHOR_BOX_PRO_PATH', plugin_dir_path( __FILE__ ) );
define( 'SIMPLE_AUTHOR_BOX_PRO_ASSETS', plugins_url( '/assets/', __FILE__ ) );
define( 'SIMPLE_AUTHOR_BOX_PRO_SLUG', plugin_basename( __FILE__ ) );
define( 'SIMPLE_AUTHOR_BOX_PRO_VERSION', '5.10' );

require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/wf-licensing.php';

function sab_pro_backwards_compatibility() {

	$taxonomies_types = array( 'category', 'post_tag' );
	$taxonomies = get_taxonomies(
		array(
			'_builtin' => false,
			'public'   => true,
		),
		'objects'
	);

	foreach ( $taxonomies as $slug => $taxonomy ) {
		$taxonomies_types[] = $slug;
	}

	$sab_options = get_option( 'saboxplugin_options', array() );

	if ( isset( $sab_options['sab_visibility_tax'] ) && is_array( $sab_options['sab_visibility_tax'] ) && ! empty( $sab_options['sab_visibility_tax'] ) ){
		
		$sab_visibility_tax = array();

		foreach ( $taxonomies_types as $taxonomies_type ) {
			if ( ! in_array( $taxonomies_type, $sab_options['sab_visibility_tax'] ) ) {
				$sab_visibility_tax[] = $taxonomies_type;
			}
		}

		unset( $sab_options['sab_visibility_tax'] );
		$sab_options['sab_tax_visibility'] = $sab_visibility_tax;
		update_option( 'saboxplugin_options', $sab_options );
	}

}
register_activation_hook( __FILE__, 'sab_pro_backwards_compatibility' );

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/class-simple-author-box-pro.php';
Simple_Author_Box_PRO::get_instance();
