<?php

class Simple_Author_Box_Top_Authors_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'sabox-top-authors', // Base ID
			esc_attr__( 'Simple Author Box - Top Authors', 'saboxpro' ), // Name
			array(
				'description'                 => esc_attr__( 'Display top authors.', 'saboxpro' ),
				'customize_selective_refresh' => true,
			)
		);

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 20 );

	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'sab-font' );
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		global $wpdb;

		echo $args['before_widget'];

		$defaults = array(
			'number' => 2,
		);

		$instance = wp_parse_args( $instance, $defaults );

		$results       = $wpdb->get_results( $wpdb->prepare( 'SELECT post_author, count( comment_count ) as popularity FROM ' . $wpdb->posts . ' WHERE post_author <> 0 GROUP BY post_author ORDER BY popularity DESC LIMIT 0, %d', array( $instance['number'] ) ), ARRAY_A );
		$sabox_options = get_option( 'saboxplugin_options' );

		if ( is_array( $results ) ) {
			foreach ( $results as $userdata ) {
				$template        = Simple_Author_Box_Helper::get_template();
				$sabox_author_id = $userdata['post_author'];
				include( $template );
			}
		}

		echo $args['after_widget'];

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		$instance['number'] = absint( $new_instance['number'] );

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$defaults = array(
			'number' => 2,
		);

		$instance = wp_parse_args( $instance, $defaults );

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'How many authors ?', 'saboxpro' ); ?></label><br/>
			<input type="text" class="widefat custom_media_url" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" value="<?php echo esc_attr( $instance['number'] ); ?>" style="margin-top:5px;">
		</p>

	<?php

	}

}
