<?php

class Simple_Author_Box_Authors_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'sabox-authors', // Base ID
			esc_attr__( 'Simple Author Box - Authors', 'saboxpro' ), // Name
			array(
				'description'                 => esc_attr__( 'Display authors.', 'saboxpro' ),
				'customize_selective_refresh' => true,
			)
		);

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 20 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

	}

	public function enqueue_scripts() {

		wp_enqueue_style( 'sab-font' );

	}

	public function admin_enqueue_scripts() {

		wp_enqueue_style( 'saboxplugin-selectize-style', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'css/selectize.css' );
		wp_enqueue_style( 'saboxplugin-selectize-default-style', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'css/selectize.default.css' );

		wp_enqueue_script( 'sabox-selectize-js', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/selectize.min.js', array(), false, true );
		wp_enqueue_script( 'sabox-widget-js', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/widgets.js', array(), false, true );

	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		global $wpdb;

		echo $args['before_widget'];

		$defaults = array(
			'title' => '',
			'users' => array(),
		);
		$instance = wp_parse_args( $instance, $defaults );

		if ( '' != $instance['title'] ) {
			echo $args['before_title'] . $instance['title'] . $args['after_title'];
		}

		if ( class_exists( 'Simple_Author_Box_Helper' ) ) {
			$sabox_options = Simple_Author_Box_Helper::get_option( 'saboxplugin_options' );
		}else{
			$sabox_options = get_option( 'saboxplugin_options' );
		}

		if ( is_array( $instance['users'] ) && ! empty( $instance['users'] ) ) {
			foreach ( $instance['users'] as $user_id ) {
				$template        = Simple_Author_Box_Helper::get_template();
				$sabox_author_id = $user_id;
				echo '<div class="sabox-plus-item">';
				include( $template );
				echo '</div>';
			}
		}

		echo $args['after_widget'];

	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['users'] = array();
		if ( is_array( $new_instance['users'] ) ) {
			foreach ( $new_instance['users'] as $key => $user_id ) {
				$instance['users'][ $key ] = absint( $user_id );
			}
		}

		return $instance;
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$defaults = array(
			'title' => esc_html__( 'Authors', 'saboxpro' ),
			'users' => array(),
		);

    $instance = wp_parse_args( $instance, $defaults );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'saboxpro' ); ?></label><br/>
			<input type="text" class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" style="margin-top:5px;">
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'users' ) ); ?>"><?php esc_html_e( 'Users:', 'saboxpro' ); ?></label><br/>
			<?php

			$name = $this->get_field_name( 'users' );
			$id   = $this->get_field_name( 'users' );

      $result = count_users();

      $users = array();
      
      foreach ( $result['avail_roles'] as $role => $count )
      {
          if ( $count > 0 ) {
  
              $args = array(
                  'role' => $role
              );
  
              $users_result = get_users( $args );
              $users = array_merge($users, $users_result);
          }
      }
			echo '<select id="' . esc_attr( $id ) . '" name="' . esc_attr( $name ) . '[]" multiple class="saboxplus-selectize">';
			echo '<option value="">' . esc_html__( 'Select users ...', 'saboxpro' ) . '</option>';
			foreach ( $users as $user ) {
				$selected = in_array( $user->ID, $instance['users'] );
				echo '<option value="' . $user->ID . '" ' . selected( $selected, 1 ) . '>' . $user->display_name .' (' . $user->user_login .')'. '</option>';
			}
			echo '</select>';

			?>
		</p>

	<?php

	}

}
