<?php


class Simple_Author_Box_PRO
{

    private static $instance = null;
    public $version;
    public $licensing_servers = array('https://dashboard.wpauthorbox.com/api/');
    private $options;

    function __construct()
    {
        global $wf_sab_licensing;

        $this->load_dependencies();
        $this->set_locale();

        $wf_sab_licensing = new WF_Licensing_SAB(array(
            'prefix' => 'wfsab',
            'licensing_servers' => $this->licensing_servers,
            'version' => SIMPLE_AUTHOR_BOX_VERSION,
            'plugin_file' => SIMPLE_AUTHOR_BOX_FILE,
            'skip_hooks' => false,
            'debug' => false,
            'js_folder' => SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/'
        ));

        add_action('plugins_loaded', array($this, 'define_admin_hooks'));
        add_action('plugins_loaded', array($this, 'define_public_hooks'));
        add_action('admin_menu', array($this, 'menu_page'));
        add_action('init', array($this, 'add_css_to_all_pages'), 20);
        add_action('sabox_field_support_output', array($this, 'generate_setting_field'));
        add_action('sabox_field_advanced_output', array($this, 'generate_setting_field'));
        add_action('sabox_field_themes_output', array($this, 'generate_setting_field'));
        add_action('sabox_field_license_output', array($this, 'generate_setting_field'));
        add_filter('admin_footer_text', array($this, 'admin_footer_text'));
        add_action('admin_head', array($this, 'brand_css'));
        add_filter('sab_logo_url', array($this, 'sab_branding_logo'), 10, 3 );
        add_filter('sab_plugin_name', array($this, 'sab_branding_plugin_name'), 10, 3 );
        add_action('admin_enqueue_scripts', array($this, 'rebranding_js'), 100, 1);
        add_filter('plugin_row_meta', array($this, 'plugin_meta_links'), 10, 2);
        add_action('admin_action_sab_export_settings', array($this, 'export_settings'));
        add_action('admin_action_sab_reset_settings', array($this, 'reset_settings'));

        if ($wf_sab_licensing->is_active()) {
            define('SIMPLE_AUTHOR_BOX_GUEST_AUTHORS', true);
        } else {
            define('SIMPLE_AUTHOR_BOX_GUEST_AUTHORS', false);
        }
    }

    public function reset_settings()
    {
        $sabox_options = array(
          'sab_autoinsert'         => '0',
          'sab_show_latest_posts'  => '0',
          'sab_show_custom_html'   => '0',
          'sab_no_description'     => '0',
          'sab_email'              => '0',
          'sab_link_target'        => '0',
          'sab_hide_socials'       => '0',
          'sab_hide_on_archive'    => '0',
          'sab_box_border_width'   => '1',
          'sab_avatar_style'       => '0',
          'sab_avatar_size'        => '100',
          'sab_avatar_hover'       => '0',
          'sab_web'                => '0',
          'sab_web_target'         => '0',
          'sab_web_rel'            => '0',
          'sab_web_position'       => '0',
          'sab_colored'            => '0',
          'sab_icons_style'        => '0',
          'sab_social_hover'       => '0',
          'sab_box_long_shadow'    => '0',
          'sab_box_thin_border'    => '0',
          'sab_box_author_color'   => '',
          'sab_box_web_color'      => '',
          'sab_box_border'         => '',
          'sab_box_icons_back'     => '',
          'sab_box_author_back'    => '',
          'sab_box_author_p_color' => '',
          'sab_box_author_a_color' => '',
          'sab_box_icons_color'    => '',
          'sab_footer_inline_style' => '',
          'sab_box_margin_top'         => '0',
          'sab_box_margin_bottom'      => '0',
          'sab_box_padding_top_bottom' => '0',
          'sab_box_padding_left_right' => '0',
          'sab_box_subset'             => 'none',
          'sab_box_name_font'          => 'None',
          'sab_box_web_font'           => 'None',
          'sab_box_desc_font'          => 'None',
          'sab_box_name_size'          => '18',
          'sab_box_web_size'           => '14',
          'sab_box_desc_size'          => '14',
          'sab_box_icon_size'          => '18',
          'sab_desc_style'             => '0',
          'sab_whitelabel' => 0,
          'saboxplugin_options' => '',
          'sab_box_job_font' => '',
          'sab_box_job_font_size' => '',
          'saboxplugin_options' => '',
          'sab_pointers' => ''
      );

      foreach($sabox_options as $sabox_option => $value){
          delete_option($sabox_option);
      }

        if (!empty($_GET['redirect'])) {
            wp_safe_redirect($_GET['redirect']);
        } else {
            wp_safe_redirect(admin_url());
        }
    }

    public function export_settings()
    {
        $options = Simple_Author_Box_Helper::get_option('saboxplugin_options');

        $filename = str_replace(array('http://', 'https://'), '', home_url());
        $filename = str_replace(array('/', '\\', '.'), '-', $filename);
        $filename .= '-' . date('Y-m-d') . '-simple-author-box-pro.txt';

        unset($options['none']);
        $options = apply_filters('sab_options_pre_export', $options);

        $out = array('type' => 'SAB', 'version' => $this->get_plugin_version(), 'data' => $options);
        $out = json_encode($out);

        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . strlen($out));

        @ob_end_clean();
        flush();

        echo $out;
        exit;
    } // export_settings

    function sab_branding_logo( $current ) {
        if (Simple_Author_Box_Pro_Helper::get_rebranding() !== false) {
            return Simple_Author_Box_Pro_Helper::get_rebranding('logo_url');
        }
        return $current;
    }

    function sab_branding_plugin_name( $current ) {
        if (Simple_Author_Box_Pro_Helper::get_rebranding() !== false) {
            return Simple_Author_Box_Pro_Helper::get_rebranding('name');
        }
        return 'Simple Author Box PRO';
    }

    function rebranding_js($hook)
    {
        if ($hook != 'plugins.php') {
            return false;
        }

        $rebranding = Simple_Author_Box_Pro_Helper::get_rebranding();
        if (false === $rebranding) {
            return false;
        }

        wp_enqueue_script('sab-branding', SIMPLE_AUTHOR_BOX_ASSETS . 'js/sab-branding.js', array('jquery'), $this->get_plugin_version(), true);
        wp_localize_script('sab-branding', 'sab_rebranding', $rebranding);
    }

    // add links to plugin's description in plugins table
    function plugin_meta_links($links, $file)
    {
        if ($file == SIMPLE_AUTHOR_BOX_SLUG && !Simple_Author_Box_Pro_Helper::whitelabel_filter()) {
            unset($links[1]);
            unset($links[2]);
            return $links;
        }

        if ($file == SIMPLE_AUTHOR_BOX_SLUG) {
            if (Simple_Author_Box_Pro_Helper::get_rebranding() !== false) {
                unset($links[1]);
                unset($links[2]);

                $links[] = '<a target="_blank" href="' . Simple_Author_Box_Pro_Helper::get_rebranding('company_url') . '" title="Get help">' . Simple_Author_Box_Pro_Helper::get_rebranding('company_name') . '</a>';
                $links[] = '<a target="_blank" href="' . Simple_Author_Box_Pro_Helper::get_rebranding('url') . '" title="Get help">Support</a>';
            } else {
                $links[] = '<a target="_blank" href="https://wpauthorbox.com/contact-us/" title="Get help">Support</a>';
            }
        }

        return $links;
    } // plugin_meta_links

    public function brand_css()
    {
        $screen = get_current_screen();
        if ($screen->id == 'appearance_page_simple-author-box' && Simple_Author_Box_Pro_Helper::get_rebranding() !== false) {
            echo '<style id="sab-brand-css">' . Simple_Author_Box_Pro_Helper::get_rebranding('admin_css_predefined') . Simple_Author_Box_Pro_Helper::get_rebranding('admin_css') . '</style>';
            $color = Simple_Author_Box_Pro_Helper::get_rebranding('color');
            $color_2nd = $this->color_luminance(str_replace('#', '', Simple_Author_Box_Pro_Helper::get_rebranding('color')), 2);
            echo '<style>';
            echo '.wp-core-ui .button-primary{
                background-color:' . $color . ';
                border-color:' . $color . ';
            }

            .wp-core-ui .button-primary:hover{
                background-color:' . $color_2nd . ';
                border-color:' . $color_2nd . ';
            }

            .sabox-table .slider-container .ui-slider .ui-slider-handle{
                background-color:' . $color . ';
            }

            .sabox-table input[type="checkbox"]:checked {
                background: ' . $color . ';
            }

            .epfw-tab.nav-tab.nav-tab-active {
                border-left: 2px solid ' . $color . ';
                color: ' . $color . ';
            }

            a {
                color:' . $color . ';
            }';
            echo '</style>';
        }
    }

    function color_luminance($hex, $percent)
    {

        // validate hex string

        $hex = preg_replace('/[^0-9a-f]/i', '', $hex);
        $new_hex = '#';

        if (strlen($hex) < 6) {
            $hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
        }

        // convert to decimal and change luminosity
        for ($i = 0; $i < 3; $i++) {
            $dec = hexdec(substr($hex, $i * 2, 2));
            $dec = min(max(0, $dec + $dec * $percent), 255);
            $new_hex .= str_pad(dechex($dec), 2, 0, STR_PAD_LEFT);
        }

        return $new_hex;
    }

    public function generate_setting_field($field_name = false)
    {
        if ($field_name == 'support') {
            echo '<td colspan="2">' . $this->support_tab() . '</td>';
            return;
        }

        if ($field_name == 'license') {
            echo '<td colspan="2">' . $this->license_tab() . '</td>';
            return;
        }
    }

    public function support_tab()
    {
        echo '<div class="clearfix"></div>';
        if (Simple_Author_Box_Pro_Helper::get_rebranding()) {
            echo Simple_Author_Box_Pro_Helper::get_rebranding('support_content');
        } else {
            echo 'Support';
        }
    }

    public function menu_page()
    {
        global $simple_author_box_admin;
        if (Simple_Author_Box_Pro_Helper::get_rebranding() !== false) {
            $plugin_name = Simple_Author_Box_Pro_Helper::get_rebranding('name');
        } else {
            $plugin_name = __('Simple Author Box Pro', 'simple-author-box');
        }
        add_theme_page($plugin_name, $plugin_name, 'manage_options', 'simple-author-box', array(
            $simple_author_box_admin,
            'setting_page',
        ));
    }

    public function license_tab()
    {
        global $wf_sab_licensing;
        $options = $this->get_options();

        $html = '<table>';
        $html .= '<tr>';

        $html .= '<td style="width:176px;">';
        $html .= '<label for="license-key">' . __('License Key', 'simple-author-box') . '</label>';
        $html .= '</td>';

        $html .= '<td>';
        $html .= '<input class="regular-text" type="text" id="license-key" value="" placeholder="' . (empty($options['license_key']) ? '12345678-12345678-12345678-12345678' : substr(esc_attr($options['license_key']), 0, 8) . '-************************') . '">';
        $html .= '</td>';
        $html .= '</tr>';

        $html .= '<tr>';
        $html .= '<td>';
        $html .=  '<label for="">' . __('License Status', 'simple-author-box') . '</label>';
        $html .= '</td>';
        $html .= '<td>';
        if ($wf_sab_licensing->is_active()) {
            $license_formatted = $wf_sab_licensing->get_license_formatted();
            $html .= '<b style="color: #66b317;">Active</b><br>
            Type: ' . $license_formatted['name_long'];
            $html .= '<br>Valid ' . $license_formatted['valid_until'] . '';
        } else {
            $html .= '<strong style="color: #ea1919;">Inactive</strong>';
            if (!empty($wf_sab_licensing->get_license('error'))) {
                $html .= '<br>Error: ' . $wf_sab_licensing->get_license('error');
            }
        }
        $html .= '</td>';
        $html .= '</tr>';
        $html .= '</table>';

        $html .= '<div class="license-buttons">';
        $html .= '<a href="#" id="save-license" data-text-wait="Validating. Please wait." class="button button-primary">Save &amp; Activate License <i class="wfsab-icon wfsab-check"></i></a>';

        if ($wf_sab_licensing->is_active()) {
            $html .= '&nbsp; &nbsp;<a href="#" id="deactivate-license" class="button button-delete">Deactivate License</a>';
        } else {
            $html .= '&nbsp; &nbsp;<a href="#" class="button button-primary" data-text-wait="Validating. Please wait." id="wfsab_keyless_activation">Keyless Activation</a>';
        }


        $html .= '<p class="wfsab-tab-description-small"><br />If you don\'t have a license - <a target="_blank" href="' . $this->generate_web_link('license-tab') . '">purchase one now</a>. In case of problems please <a href="#" class="open-beacon">contact support</a>. You can manage your licenses in the <a target="_blank" href="' . $this->generate_dashboard_link('license-tab') . '">Simple Author Box Dashboard</a></p>';

        if ($wf_sab_licensing->is_active('white_label')) {
            $html .= '<br><br>';
            $html .= '<hr>';
            $html .= '<p><a href="' . admin_url('themes.php?page=simple-author-box&sab_wl=true') . '" class="button button-secondary js-action">Enable White-Label License Mode</a></p>';
            $html .= '<p>Enabling the white-label license mode hides License and Support tabs, and removes visible mentions of WebFactory Ltd.<br>';
            $html .= 'To disable it append <strong>&amp;sab_wl=false</strong> to the Simple Author Box settings page URL.';
            $html .= 'Or save this URL and open it when you want to disable the white-label license mode:<br> <a href="' . admin_url('themes.php?page=simple-author-box&sab_wl=false') . '">' . admin_url('themes.php?page=simple-author-box<strong>&amp;sab_wl=false</strong>') . '</a></p>';
        }

        $html .= '</div>';
        return $html;
    }

    public function advanced_tab()
    {
        global $simple_author_box_admin;

        $html = '';
        $html .= '<table class="form-table sabox-table"><tbody>';

        $html .= '<tr valign="top" class="">';
        $html .= '<th scope="row">Export Settings';
        $html .= '<span class="epfw-description">All settings are exported except license details. You can safely transfer (export and then import) settings between different domains/sites.</span></th>';
        $html .= '<td align="right"><a class="button button-primary" id="sab-export-settings" href="' . add_query_arg(array('action' => 'sab_export_settings'), admin_url('admin.php')) . '">Export Settings</a></td>';
        $html .= '</tr>';

        $html .= '<tr valign="top" class="">';
        $html .= '<th scope="row">Import Settings';
        $html .= '<span class="epfw-description">All settings are imported and overwritten except license details.</span></th>';
        $html .= '<td align="right"><div class="file-upload">
        <label class="file-upload__label" for="sab_settings_import">Select File</label>
        <input class="file-upload__input" type="file" name="sab_settings_import" id="sab_settings_import" accept=".txt">
        </div>
        <input type="submit" name="submit-import" id="submit-import" class="button button-primary" data-confirm="Are you sure you want to import settings? All current settings will be overwritten. There is NO UNDO!" value="Import Settings"></td>';
        $html .= '</tr>';

        $html .= '<tr valign="top" class="">';
        $html .= '<th scope="row">Reset All Settings';
        $html .= '<span class="epfw-description">All settings are reset to default values except license details. There is NO undo.</span></th>';
        $html .= '<td align="right"><a class="button button-primary confirm-action" data-confirm="Are you sure you want to reset all settings? There is NO undo!" id="sab-reset-settings" href="' . add_query_arg(array('action' => 'sab_reset_settings', 'redirect' => admin_url('themes.php?page=simple-author-box')), admin_url('admin.php')) . '">Reset Settings</a></td>';
        $html .= '</tr>';

        $html .= '</table>';

        return $html;
    }


    public static function get_instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    private function get_options()
    {
        if ($this->options == null) {
            if (class_exists('Simple_Author_Box_Helper')) {
                $this->options = Simple_Author_Box_Helper::get_option('saboxplugin_options');
            } else {
                $this->options = get_option('saboxplugin_options');
            }
        }

        return $this->options;
    }


    /**
     * Admin footer text
     *
     * @since 5.0
     *
     * @return null
     */
    public function admin_footer_text($text)
    {
        if (!$this->is_plugin_page()) {
            return $text;
        }

        if (Simple_Author_Box_Pro_Helper::get_rebranding()) {
            $text = '<i class="wfsab-footer"><a href="' . Simple_Author_Box_Pro_Helper::get_rebranding('url') . '" title="Visit ' . Simple_Author_Box_Pro_Helper::get_rebranding('name') . ' page for more info" target="_blank">' . Simple_Author_Box_Pro_Helper::get_rebranding('name') . '</a> v' . $this->get_plugin_version() . '</i>';
        } else {
            $text = '<i class="wfsab-footer">Thank you for creating with <a href="' . $this->generate_web_link('admin_footer') . '" title="' . __('Visit Simple Author Box PRO page for more info', 'simple-author-box-pro') . '" target="_blank">Simple Author Box PRO</a> v' . $this->get_plugin_version() . '</i>';
        }

        echo '<script type="text/javascript">!function(e,t,n){function a(){var e=t.getElementsByTagName("script")[0],n=t.createElement("script");n.type="text/javascript",n.async=!0,n.src="https://beacon-v2.helpscout.net",e.parentNode.insertBefore(n,e)}if(e.Beacon=n=function(t,n,a){e.Beacon.readyQueue.push({method:t,options:n,data:a})},n.readyQueue=[],"complete"===t.readyState)return a();e.attachEvent?e.attachEvent("onload",a):e.addEventListener("load",a,!1)}(window,document,window.Beacon||function(){});</script>';

        return $text;
    } // admin_footer_text


    /**
     * Helper function for generating UTM tagged links
     *
     * @param string  $placement  Optional. UTM content param.
     * @param string  $page       Optional. Page to link to.
     * @param array   $params     Optional. Extra URL params.
     * @param string  $anchor     Optional. URL anchor part.
     *
     * @return string
     */
    public function generate_web_link($placement = '', $page = '/', $params = array(), $anchor = '')
    {
        $base_url = 'https://wpauthorbox.com';

        if ('/' != $page) {
            $page = '/' . trim($page, '/') . '/';
        }
        if ($page == '//') {
            $page = '/';
        }

        $parts = array_merge(array('utm_source' => 'sab-free', 'utm_content' => $placement), $params);

        if (!empty($anchor)) {
            $anchor = '#' . trim($anchor, '#');
        }

        $out = $base_url . $page . '?' . http_build_query($parts, '', '&amp;') . $anchor;

        return $out;
    } // generate_web_link


    /**
     * Get plugin version
     *
     * @since 5.0
     *
     * @return int plugin version
     *
     */
    public function get_plugin_version()
    {
        if (isset($this->version)) {
            return $this->version;
        }

        $plugin_data = get_file_data(SIMPLE_AUTHOR_BOX_FILE, array('version' => 'Version'), 'plugin');
        $this->version = $plugin_data['version'];

        return $plugin_data['version'];
    } // get_plugin_version


    /**
     * Helper function for generating dashboard UTM tagged links
     *
     * @param string  $placement  Optional. UTM content param.
     * @param string  $page       Optional. Page to link to.
     * @param array   $params     Optional. Extra URL params.
     * @param string  $anchor     Optional. URL anchor part.
     *
     * @return string
     */
    public function generate_dashboard_link($placement = '', $page = '/', $params = array(), $anchor = '')
    {
        $base_url = 'https://dashboard.wpauthorbox.com';

        if ('/' != $page) {
            $page = '/' . trim($page, '/') . '/';
        }
        if ($page == '//') {
            $page = '/';
        }

        $parts = array_merge(array('utm_source' => 'simple-author-box-pro', 'utm_medium' => 'plugin', 'utm_content' => $placement, 'utm_campaign' => 'simple-author-box-pro' . $this->get_plugin_version()), $params);

        if (!empty($anchor)) {
            $anchor = '#' . trim($anchor, '#');
        }

        $out = $base_url . $page . '?' . http_build_query($parts, '', '&amp;') . $anchor;

        return $out;
    } // generate_dashboard_link


    /**
     * Test if we're on plugin's page
     *
     * @since 5.0
     *
     * @return null
     */
    public function is_plugin_page()
    {
        $current_screen = get_current_screen();

        if ($current_screen->id == 'appearance_page_simple-author-box') {
            return true;
        } else {
            return false;
        }
    } // is_plugin_page

    public function add_css_to_all_pages()
    {

        if (is_single() || is_page() || is_author() || is_archive()) {
            return;
        }

        $options = $this->get_options();

        if (isset($options['sab_footer_inline_style']) && '1' == $options['sab_footer_inline_style']) {
            add_action('wp_footer', array($this, 'inline_style'), 13);
        } else {
            add_action('wp_head', array($this, 'inline_style'), 15);
        }
    }

    public function inline_style()
    {

        $style = '<style type="text/css">';
        $style .= Simple_Author_Box_Helper::generate_inline_css();
        $style .= '</style>';


        $style .= '<script>';
        $style .= '(function ($) {
            $(document).ready(function () {
                $(".saboxplugin-tabs-wrapper").on("click", "li", function () {
                    $(this).parents(".saboxplugin-wrap").children(".saboxplugin-tab").hide();
                    $(this).parents(".saboxplugin-wrap").children(".saboxplugin-tab-" + $(this).data("tab")).show();
                });
            });
        })(jQuery);';
        $style .= '</script>';
        echo $style;
    }

    private function load_dependencies()
    {

        require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/class-simple-author-box-pro-helper.php';
        require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/class-simple-author-box-guest-authors.php';

        // Widgets
        require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/widgets/class-simple-author-box-top-authors-widget.php';
        require_once SIMPLE_AUTHOR_BOX_PRO_PATH . 'inc/widgets/class-simple-author-box-authors-widget.php';
    }

    private function set_locale()
    {
        //load_plugin_textdomain('simple-author-box');
    }

    public function define_admin_hooks()
    {
        global $wf_sab_licensing;
        if (!is_admin()) {
            return;
        }

        add_filter('sabox_admin_settings', array($this, 'add_new_settings'));
        add_filter('sabox_admin_sections', array($this, 'add_new_sections'));

        add_action('admin_enqueue_scripts', array($this, 'admin_style_and_scripts'), 11);

        if ($wf_sab_licensing->is_active()) {
            // Add job information to user profile
            add_action('show_user_profile', array($this, 'add_profile_fields'), 9, 1);
            add_action('edit_user_profile', array($this, 'add_profile_fields'), 9, 1);


            add_action('personal_options_update', array($this, 'save_user_profile'));
            add_action('edit_user_profile_update', array($this, 'save_user_profile'));

            // Author page description
            $options = $this->get_options();
            if (isset($options['sabox_author_different_description']) && $options['sabox_author_different_description'] == '1') {
                add_action('show_user_profile', array($this, 'author_page_text'));
                add_action('edit_user_profile', array($this, 'author_page_text'));
            }
        }

        // Remove upsell from SAB
        add_filter('sabox_show_upsell', '__return_false');

        // Change title from Simple Author box to Simple Author Box PRO
        add_filter('sabox_show_pro_title', array($this, 'sabox_pro_title'));

        // Change version to SAB PRO version
        add_filter('sabox_show_pro_version', array($this, 'sabox_pro_version'));

        // Hide changelog as for SAB PRO it's not public
        add_filter('sabox_show_changelog', '__return_false');

        // Add job to Previewer
        add_filter('sabox_preview_author_html', array($this, 'add_job_title_to_previewer'));

        add_action('add_meta_boxes', array($this, 'sab_meta_box'));
        add_action('save_post', array($this, 'sab_save_field'));
    }


    // Check post types where sab elementor widget should be displayed
    public function sab_extend_elementor_types()
    {
        $options = Simple_Author_Box_Helper::get_option('saboxplugin_options');
        $enabled_posts_types = $options['sab_visibility'];
        return $enabled_posts_types;
    }

    public function sabox_pro_title()
    {
        return __('Simple Author Box', 'simple-author-box');
    }

    public function sabox_pro_version()
    {
        return SIMPLE_AUTHOR_BOX_PRO_VERSION;
    }

    public function add_job_title_to_previewer($html)
    {
        $html .= '<span class="sabox-job-title">( Web Developer )</span>';

        return $html;
    }

    public function define_public_hooks()
    {

        add_filter('sabox_check_if_show', array($this, 'check_if_show'), 20);
        add_filter('sabox_check_if_show_post_author_box', array($this, 'show_only_guests'), 20);

        add_filter('sabox_get_template_part', array($this, 'add_guest_author_template'), 10, 2);
        add_filter('sabox_author_html', array($this, 'sabox_author_html'), 10, 3);
        add_filter('sabox_google_fonts', array($this, 'add_google_fonts'));
        add_filter('sabox_inline_css', array($this, 'add_inline_css'));
        add_filter('sabox-previewer-css', array($this, 'add_inline_css'));

        add_filter('sab_box_options_defaults', array($this, 'add_pro_defauls'));

        // Filter the sabox html in order to move it on top if necessary
        add_filter('sabox_return_html', array($this, 'positioning_sabox'), 15, 3);

        // Filter author description
        add_filter('sab_user_description', array($this, 'user_description'), 10, 2);

        add_action('sabox_after_author_box', array($this, 'show_guest_author'));
        //add_filter( 'the_author',                  array( $this, 'author_name' ), 12 );
        //add_filter( 'get_the_author_display_name', array( $this, 'author_name' ), 12 );
        //add_filter( 'get_the_author_user_nicename', array( $this, 'author_name' ), 12 );
        //add_filter( 'get_the_author_nickname',      array( $this, 'author_name' ), 12 );
        add_action('widgets_init', array($this, 'register_widgets'));

        $options = $this->get_options();
        if ('1' == $options['sab_footer_inline_style']) {
            add_action('wp_footer', array($this, 'pro_inline_style'), 10);
        } else {
            add_action('wp_head', array($this, 'pro_inline_style'), 10);
        }

        // Elementor widget display based on post types
        add_filter('sab_elementor_types', array($this, 'sab_extend_elementor_types'));
        add_action('wp_ajax_sab_editor_unsplash_api', array($this, 'sab_editor_unsplash_api'));
        add_action('wp_ajax_sab_editor_unsplash_download', array($this, 'sab_editor_unsplash_download'));
    }


    public function sab_editor_unsplash_download()
    {
        global $wf_sab_licensing;

        $params['request'] = 'photos';
        $params['action'] = 'get_images';
        $params['image_id'] = $_POST['image_id'];

        $response = $wf_sab_licensing->query_licensing_server('unsplash_api', array('request_details' => serialize($params)));

        if (is_wp_error($response)) {
            wp_send_json_error('Images API is temporarily not available. ' . $url);
        } else {
            $unsplash_image_link = json_decode($response['data']);
            $image_url = $unsplash_image_link->url;
            $image_name = $_POST['image_name'];
            $image_query = '&w=4000&h=4000&q=75';
            $image_src = $this->sab_media_sideload_image($image_url . '&format=.jpg' . $image_query, 0, false, $image_name, 'src');
            if (!is_wp_error($image_src)) {
                wp_send_json_success($image_src);
            } else {
                wp_send_json_error($image_src->get_error_message());
            }
        }
        die();
    } // sab_editor_unsplash_download

    public function sab_media_sideload_image($url = null, $post_id = null, $thumb = null, $filename = null, $return = 'id')
    {
        if (!$url) return new WP_Error('missing', "Need a valid URL and post ID...");
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        // Download file to temp location, returns full server path to temp file, ex; /home/user/public_html/mysite/wp-content/26192277_640.tmp
        $tmp = download_url($url);
        // If error storing temporarily, unlink
        if (is_wp_error($tmp)) {
            @unlink($file_array['tmp_name']);   // clean up
            $file_array['tmp_name'] = '';
            return $tmp; // output wp_error
        }
        preg_match('/[^\?]+\.(jpg|JPG|jpe|JPE|jpeg|JPEG|gif|GIF|png|PNG)/', $url, $matches);    // fix file filename for query strings
        $url_filename = basename($matches[0]);                                                  // extract filename from url for title
        $url_type = wp_check_filetype($url_filename);                                           // determine file type (ext and mime/type)
        // override filename if given, reconstruct server path
        if (!empty($filename)) {
            $filename = sanitize_file_name($filename);
            $tmppath = pathinfo($tmp);                                                        // extract path parts
            $new = $tmppath['dirname'] . "/" . $filename . "." . $tmppath['extension'];          // build new path
            rename($tmp, $new);                                                                 // renames temp file on server
            $tmp = $new;                                                                        // push new filename (in path) to be used in file array later
        }
        // assemble file data (should be built like $_FILES since wp_handle_sideload() will be using)
        $file_array['tmp_name'] = $tmp;                                                         // full server path to temp file
        if (!empty($filename)) {
            $file_array['name'] = $filename . "." . $url_type['ext'];                           // user given filename for title, add original URL extension
        } else {
            $file_array['name'] = $url_filename;                                                // just use original URL filename
        }
        // set additional wp_posts columns
        if (empty($post_data['post_title'])) {
            $post_data['post_title'] = basename($url_filename, "." . $url_type['ext']);         // just use the original filename (no extension)
        }
        // make sure gets tied to parent
        if (empty($post_data['post_parent'])) {
            $post_data['post_parent'] = $post_id;
        }
        // required libraries for media_handle_sideload
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once(ABSPATH . 'wp-admin/includes/media.php');
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        // do the validation and storage stuff
        $att_id = media_handle_sideload($file_array, $post_id, null, $post_data);             // $post_data can override the items saved to wp_posts table, like post_mime_type, guid, post_parent, post_title, post_content, post_status
        // If error storing permanently, unlink
        if (is_wp_error($att_id)) {
            @unlink($file_array['tmp_name']);   // clean up
            return $att_id; // output wp_error
        }
        // set as post thumbnail if desired
        if ($thumb) {
            set_post_thumbnail($post_id, $att_id);
        }
        if ($return == 'src') {
            return wp_get_attachment_url($att_id);
        }
        return $att_id;
    }

    public function sab_editor_unsplash_api()
    {
        global $wf_sab_licensing;

        $params['request'] = 'photos';
        $params['page'] = (int) $_POST['page'];
        $params['per_page'] = (int) $_POST['per_page'];
        $params['search'] = substr(trim($_POST['search']), 0, 128);
        $params['action'] = 'get_images';
        $response = $wf_sab_licensing->query_licensing_server('unsplash_api', array('request_details' => serialize($params)));

        if (is_wp_error($response)) {
            wp_send_json_error('Images API is temporarily not available.');
        } else {
            $photos_unsplash_response = json_decode($response['data']);

            $photos_response = array();
            $total_pages = false;
            $total_results = false;

            if (isset($photos_unsplash_response->total)) {
                $total_results = $photos_unsplash_response->total;
                $total_pages = $photos_unsplash_response->total_pages;
                $photos_unsplash = $photos_unsplash_response->results;
            } else {
                $photos_unsplash = $photos_unsplash_response;
            }

            if (is_array($photos_unsplash) && count($photos_unsplash) > 0) {
                foreach ($photos_unsplash as $photo_data) {
                    $image_name = $photo_data->id;
                    if (strlen($photo_data->description) > 0) {
                        $image_name = sanitize_title(substr($photo_data->description, 0, 50));
                    }
                    $photo_response[] = array('id' => $photo_data->id, 'name' => $image_name, 'thumb' => $photo_data->urls->thumb, 'full' => $photo_data->urls->full, 'user' => '<a class="unsplash-user" href="https://unsplash.com/@' . $photo_data->user->username . '/?utm_source=Coming+Soon+demo&utm_medium=referral" target="_blank">' . $photo_data->user->name . '</a>');
                }
            }
            if (!isset($photo_response) || count($photo_response) == 0) {
                wp_send_json_error('Images API is temporarily not available.');
            } else {
                wp_send_json_success(array('results' => json_encode($photo_response), 'total_pages' => $total_pages, 'total_results' => $total_results));
            }
        }
        die();
    } // sab_editor_unsplash_api

    public function register_widgets()
    {
        register_widget('Simple_Author_Box_Top_Authors_Widget');
        register_widget('Simple_Author_Box_Authors_Widget');
    }

    public function author_name()
    {
        global $post;
        if (isset($this->options['enable_guest_authors']) && $this->options['enable_guest_authors'] != '0') {
            $co_authors         = get_post_meta($post->ID, 'sabox-coauthors', true);

            if (is_array($co_authors) && !empty($co_authors)) {
                foreach ($co_authors as $co_author) {
                    $sabox_author_id = $co_author;
                    echo "!!";
                    //return esc_html( get_the_author_meta( 'display_name', $sabox_author_id ) );
                }
            }
        }
        return "??";
    }

    public function admin_style_and_scripts($hook)
    {
        global $wf_sab_licensing;

        $suffix = '.min';
        if (SIMPLE_AUTHOR_SCRIPT_DEBUG) {
            $suffix = '';
        }

        if(!empty($wf_sab_licensing)){
            $license = $wf_sab_licensing->get_license();
        } else {
            $license = false;
        }

        $current_user = wp_get_current_user();

        if ('appearance_page_simple-author-box' == $hook) {

            $support_text = 'My site details: WP ' . get_bloginfo('version') . ', SAB v' . $this->get_plugin_version() . ', ';
            if (!empty($license['license_key'])) {
                $support_text .= 'license key: ' . $license['license_key'] . '.';
            } else {
                $support_text .= 'no license info.';
            }

            if (strtolower($current_user->display_name) != 'admin' && strtolower($current_user->display_name) != 'administrator') {
                $support_name = $current_user->display_name;
            } else {
                $support_name = '';
            }

            $sabox_admin['support_name'] = $support_name;
            $sabox_admin['support_text'] = $support_text;

            $sab = Simple_Author_Box_PRO::get_instance();
            $sabox_admin['themes'] = Simple_Author_Box_Helper::get_themes();
            $sabox_admin['rebranding'] = Simple_Author_Box_Pro_Helper::get_rebranding();
            $sabox_admin['whitelabel'] = Simple_Author_Box_Pro_Helper::whitelabel_filter();

            // Add css & js files for settings' page
            wp_enqueue_style('saboxpro-admin-style', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'css/sabox-pro-admin.css', false, $this->get_plugin_version());
            wp_enqueue_script('saboxpro-admin-js', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/saboxpro-admin.js', array(), $this->get_plugin_version(), true);
            wp_enqueue_script('saboxpro-preview', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/sabox-pro-preview.js', array(), $this->get_plugin_version(), true);
            wp_localize_script('sabox-sweetalert', 'sabox_admin_pro', $sabox_admin);
        } elseif ('profile.php' == $hook || 'user-edit.php' == $hook) {

            wp_enqueue_style('saboxplugin-edit-user-style', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'css/edit-user.css');
            wp_enqueue_script('saboxpro-edit-user-js', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/user-profile.js', array('jquery-ui-sortable'), $this->get_plugin_version(), true);
        } elseif ('post.php' == $hook || 'post-new.php' == $hook) {

            wp_enqueue_style('saboxplugin-guest-user-style', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'css/guest-user.css');
            wp_enqueue_script('saboxpro-guest-user-js', SIMPLE_AUTHOR_BOX_PRO_ASSETS . 'js/guest-user.js', array('jquery-ui-sortable'), $this->get_plugin_version(), true);
        }
    }

    public function add_new_settings($settings)
    {
        $settings['license'] = array(
            'license' => array('type' => 'license')
        );

        if(false !== Simple_Author_Box_Pro_Helper::get_rebranding()){
            $settings['support'] = array(
                'support' => array('type' => 'support')
            );
        }

        return $settings;
    }

    public function add_new_sections($sections)
    {
        if(false !== Simple_Author_Box_Pro_Helper::get_rebranding()){
            $sections['support'] = array(
                'label' => __('Support', 'simple-author-box')
            );
        }

        $sections['license'] = array(
            'label' => __('License', 'simple-author-box')
        );

        return $sections;
    }

    public function check_if_show($show)
    {
        $options = Simple_Author_Box_Helper::get_option('saboxplugin_options');

        if (1 == $this->options['sab_hide_on_archive'] && is_archive()) {
            return false;
        }

        if (isset($options['sab_visibility']) && $options['sab_visibility'] != 0) {
            $custom_post_types = $options['sab_visibility'];
        } else {
            $custom_post_types = array();
        }

        $taxonomies = isset($options['sab_tax_visibility']) ? $options['sab_tax_visibility'] : array();
        if (!is_array($taxonomies)) {
            $taxonomies = array();
        }

        $post_type = get_post_type();
        $return = false;



        if (!empty($custom_post_types)) {

            foreach ($custom_post_types as $custom_post_type) {

                if ('post' == $custom_post_type && 'post' == $post_type) {
                    if (is_singular('post')) {
                        $hide = get_post_meta(get_the_ID(), '_disable_sab_here', true);

                        if (!$hide) {
                            $return = true;
                        }
                    } else {

                        if ('0' == $options['sab_hide_on_archive'] && is_archive()) {
                            if (in_array('category', $taxonomies) && is_category()) {
                                $hide = get_post_meta(get_the_ID(), '_disable_sab_here', true);
                                if (!$hide) {
                                    $return = false;
                                }
                            } elseif (in_array('category', $taxonomies) && is_tag()) {

                                $hide = get_post_meta(get_the_ID(), '_disable_sab_here', true);

                                if (!$hide) {
                                    $return = true;
                                }
                            } else {
                                $return = false;
                            }
                        }
                    }
                }
                if ('page' == $custom_post_type && 'page' == $post_type) {
                    if (is_page()) {

                        $hide = get_post_meta(get_the_ID(), '_disable_sab_here', true);
                        if (!$hide) {
                            $return = true;
                        }
                    }
                }

                if ('post' != $custom_post_type && 'page' != $custom_post_type) {

                    if (is_singular($custom_post_type)) {
                        $hide = get_post_meta(get_the_ID(), '_disable_sab_here', false);

                        if (!$hide) {
                            $return = true;
                        }
                    } else {
                        if ('0' == $options['sab_hide_on_archive'] && is_archive()) {
                            $post_type_taxonomies = get_object_taxonomies($custom_post_type);
                            foreach ($post_type_taxonomies as $taxonomy) {

                                if (is_tax($taxonomy) && in_array($taxonomy, $taxonomies)) {
                                    $hide = get_post_meta(get_the_ID(), '_disable_sab_here', true);

                                    if (!$hide) {
                                        $return = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (1 == $this->options['sab_hide_on_archive'] && !is_single()) {
                return false;
            }
        }

        return $return;
    }

    public function show_only_guests($show)
    {
        $options = Simple_Author_Box_Helper::get_option('saboxplugin_options');
        if (!is_single()) {
            return $show;
        }

        $hide_author_box = get_post_meta(get_the_ID(), '_disable_sab_author_only', true);

        if ($hide_author_box && '1' == $options['enable_guest_authors']) {
            return false;
        }

        return $show;
    }

    public function add_guest_author_template($template, $template_name)
    {

        if (SIMPLE_AUTHOR_BOX_PATH . 'template/template-sab.php' == $template && 'template-guest-author.php' == $template_name) {
            $template = SIMPLE_AUTHOR_BOX_PRO_PATH . 'template/template-guest-author.php';
        }

        return $template;
    }

    public function sabox_author_html($html, $sabox_options, $sabox_author_id)
    {

        if (isset($sabox_options['sab_author_link'])) {
            if ('author-page' == $sabox_options['sab_author_link']) {

                $link = get_user_meta($sabox_author_id, 'sab_box_link', true);
                if (empty($link))
                    $link = get_author_posts_url($sabox_author_id);

                $html = sprintf('<a href="%s" class="vcard author" rel="author" itemprop="url"><span class="fn" itemprop="name">%s</span></a>', esc_url($link), esc_html(get_the_author_meta('display_name', $sabox_author_id)));
            } elseif ('author-website' == $sabox_options['sab_author_link']) {
                $nofollow = '';
                if (isset($sabox_options['sab_author_link_noffolow']) && '1' == $sabox_options['sab_author_link_noffolow']) {
                    $nofollow = ' rel="nofollow"';
                }

                $html = sprintf('<a href="%s" class="vcard author" %s rel="author" itemprop="url"><span class="fn" itemprop="name">%s</span></a>', esc_url(get_the_author_meta('user_url', $sabox_author_id)), $nofollow, esc_html(get_the_author_meta('display_name', $sabox_author_id)));
            } else {
                $html = sprintf('<span class="fn" itemprop="name">%s</span>', esc_html(get_the_author_meta('display_name', $sabox_author_id)));
            }
        }

        $job_title = get_the_author_meta('sab_box_job_title', $sabox_author_id);

        if ('' != $job_title) {
            $lbracket = $sabox_options['sab_hide_brackets'] == '1' ? "" : "(";
            $rbracket = $sabox_options['sab_hide_brackets'] == '1' ? "" : ")";
            $html .= '<span class="sabox-job-title" itemprop="jobTitle"><span class="sabox-job-title-par">' . $lbracket . '</span> ' . $job_title . ' <span class="sabox-job-title-par">' . $rbracket . '</span></span>';
        }

        return $html;
    }

    public function show_guest_author($sabox_options)
    {

        global $post;
        if (isset($sabox_options['enable_guest_authors']) && $sabox_options['enable_guest_authors'] != '0') {

            $template           = Simple_Author_Box_Helper::get_template('template-guest-author.php');
            $co_authors         = get_post_meta($post->ID, 'sabox-coauthors', true);

            $sabox_guest_author = false;

            if (is_array($co_authors) && !empty($co_authors)) {

                if (isset($sabox_options['co_authors']) && '0' != $sabox_options['co_authors']) {
                    if (isset($sabox_options['co_authors_custom']) && $sabox_options['co_authors_custom'] == '1') {
                        echo '<h2 class="sabox-guest-authors">' . esc_html($sabox_options['co_authors_custom_text']) . '</h2>';
                    } else {
                        echo '<h2 class="sabox-guest-authors">' . esc_html__('Co Authors :', 'simple-author-box') . '</h2>';
                    }
                } else {
                    $sabox_guest_author = true;
                }

                echo "<div class='sabox-guest-authors-container'>";
                foreach ($co_authors as $co_author) {
                    $sabox_author_id = $co_author;
                    include($template);
                }
                echo "</div>";
            }
        }
    }

    public function add_profile_fields($user)
    {
        $job_title = get_user_meta($user->ID, 'sab_box_job_title', true);
        $author_html = get_user_meta($user->ID, 'sab_box_author_html', true);
?>
        <div id="sabox-custom-job-title">
            <h3><?php _e('Simple Author Box', 'simple-author-box'); ?></h3>
            <table class="form-table">
                <tr>
                    <th><label for="cupp_meta"><?php _e('Job Title', 'simple-author-box'); ?></label></th>
                    <td>
                        <input type="text" name="sabox-pro-job-title" id="sabox-pro-job-title" value="<?php echo esc_attr($job_title); ?>" class="regular-text code">
                    </td>
                </tr>

                <tr>
                    <th><label for="cupp_meta"><?php _e('Author Custom HTML Tab Content', 'simple-author-box'); ?></label></th>
                    <td>
                        <textarea name="sabox-pro-author-html" id="sabox-pro-author-html" class="regular-text code"><?php echo $author_html; ?></textarea>
                    </td>
                </tr>
            </table>
        </div>
        <?php

        $link = get_user_meta($user->ID, 'sab_box_link', true);
        ?>
        <div id="sabox-custom-link">
            <table class="form-table">
                <tr>
                    <th><label for="cupp_meta"><?php _e("Link to author's page", 'simple-author-box'); ?></label></th>
                    <td>
                        <input type="text" name="sabox-pro-link" id="sabox-pro-link" value="<?php echo esc_attr($link); ?>" class="regular-text code">
                    </td>
                </tr>
            </table>
        </div>
    <?php
    }


    public function pro_inline_style()
    {
        $style = '<style type="text/css">';
        $style .= Simple_Author_Box_Pro_Helper::pro_generate_inline_css();
        $style .= '</style>';

        echo $style;
    }

    public function save_user_profile($user_id)
    {

        if (isset($_POST['sabox-pro-job-title'])) {

            if ('' == $_POST['sabox-pro-job-title']) {
                delete_user_meta($user_id, 'sab_box_job_title');
            } else {
                update_user_meta($user_id, 'sab_box_job_title', sanitize_text_field($_POST['sabox-pro-job-title']));
            }
        }

        if (isset($_POST['sabox-pro-author-html'])) {

            if ('' == $_POST['sabox-pro-author-html']) {
                delete_user_meta($user_id, 'sab_box_author_html');
            } else {
                update_user_meta($user_id, 'sab_box_author_html', $_POST['sabox-pro-author-html']);
            }
        }

        if (isset($_POST['sabox-pro-link'])) {

            if ('' == $_POST['sabox-pro-link']) {
                delete_user_meta($user_id, 'sab_box_link');
            } else {
                update_user_meta($user_id, 'sab_box_link', sanitize_text_field($_POST['sabox-pro-link']));
            }
        }

        if (isset($_POST['sabox_author_different_description']) && '' != $_POST['sabox_author_different_description']) {
            update_user_meta($user_id, 'sabox_author_different_description', wp_filter_post_kses($_POST['sabox_author_different_description']));
        } else {
            delete_user_meta($user_id, 'sabox_author_different_description');
        }
    }

    public function add_google_fonts($google_fonts)
    {

        $sab_author_font = get_option('sab_box_name_font');
        $sab_desc_font   = get_option('sab_box_desc_font');
        $sab_web_font    = get_option('sab_box_web_font');
        $sab_job_font    = get_option('sab_box_job_font');

        if ('' != $sab_job_font && $sab_job_font != $sab_web_font && $sab_job_font != $sab_desc_font && $sab_job_font != $sab_author_font) {
            $google_fonts[] = str_replace(' ', '+', esc_attr($sab_job_font)) . ':400';
        }

        return $google_fonts;
    }

    public function add_inline_css($css)
    {

        $sab_job_font      = get_option('sab_box_job_font', 'inherit');
        $sab_job_font_size = get_option('sab_box_job_font_size', '12');

        $style = '';
        if ($sab_job_font && 'None' != $sab_job_font) {
            $style .= 'font-family:' . esc_attr($sab_job_font) . ';';
        }
        if ($sab_job_font) {
            $style .= 'font-size:' . absint($sab_job_font_size) . 'px;';
        }

        $css .= '.saboxplugin-authorname .sabox-job-title{' . $style . 'opacity:.7;display: inline-block;margin-left: 10px;}';

        return $css;
    }

    public function positioning_sabox($html, $sabox, $content)
    {

        $options = $this->get_options();
        if (isset($options['sab_position']) && 'top' == $options['sab_position']) {
            return $sabox . $content;
        }

        return $html;
    }

    public function user_description($description, $sabox_author_id)
    {
        $options = $this->get_options();

        if ('1' == $options['sabox_author_different_description']) {
            $description = get_the_author_meta('sabox_author_different_description', $sabox_author_id);
        }

        return $description;
    }

    public function sab_meta_box()
    {

        global $post_type, $post_type_object;

        $options = $options = $this->get_options();

        if (isset($options['sab_visibility']) && $options['sab_visibility'] != 0) {
            $custom_post_types = $options['sab_visibility'];
        } else {
            $custom_post_types = array();
        }

        if (!empty($custom_post_types) && post_type_supports($post_type, 'author') && (in_array($post_type, $custom_post_types))) {
            add_meta_box('display_sab', __('Simple Author Box Settings', 'simple-author-box'), array(
                $this,
                'display_sab_meta_box'
            ), $post_type, 'side', 'high');
        }
    }

    public function display_sab_meta_box($post)
    {
        wp_nonce_field('sabox-remove-box-here', 'sabox-remove-box-nonce');
        $disabled  = get_post_meta($post->ID, '_disable_sab_here', true);
        $show_only = get_post_meta($post->ID, '_disable_sab_author_only', true);
        $options   = Simple_Author_Box_Helper::get_option('saboxplugin_options');
    ?>
        <p>
            <input id="disable_sab" type="checkbox" name="disable_sab" <?php checked('1', $disabled, true); ?>>
            <label for="disable_sab"><?php _e('Hide Author Box', 'simple-author-box'); ?></label>
        </p>
        <?php if (isset($options['enable_guest_authors']) && $options['enable_guest_authors'] == '1') {
        ?>
            <p>
                <input id="disable_sab_author_only" type="checkbox" name="disable_sab_author_only" <?php checked('1', $show_only, true); ?>>
                <label for="disable_sab_author_only"><?php _e('Show only guest/co authors', 'simple-author-box'); ?></label>
            </p>
        <?php

        }
    }

    public function sab_save_field($post_id)
    {
        global $post_type_object;

        if (!isset($_POST['sabox-remove-box-nonce'])) {
            return $post_id;
        }

        $nonce = $_POST['sabox-remove-box-nonce'];

        // Verify that the nonce is valid.
        if (!wp_verify_nonce($nonce, 'sabox-remove-box-here')) {
            return $post_id;
        }

        if (!current_user_can($post_type_object->cap->edit_others_posts)) {
            return $post_id;
        }

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }

        if (isset($_POST['disable_sab'])) {
            update_post_meta($post_id, '_disable_sab_here', '1');
        } else {
            delete_post_meta($post_id, '_disable_sab_here');
        }

        if (isset($_POST['disable_sab_author_only'])) {
            update_post_meta($post_id, '_disable_sab_author_only', '1');
        } else {
            delete_post_meta($post_id, '_disable_sab_author_only');
        }
    }

    // User description for author page.
    public function author_page_text($user)
    {

        $author_page_description = get_user_meta($user->ID, 'sabox_author_different_description', true);

        ?>
        <div id="sabox-custom-profile-image">
            <h3><?php esc_html_e('Author page user description (Simple Author Box)', 'simple-author-box'); ?></h3>
            <table class="form-table">
                <tr>
                    <th><label for="cupp_meta"><?php esc_html_e('Custom Biography', 'simple-author-box'); ?></label></th>
                    <td>
                        <textarea id="sabox_author_different_description" class="sab-editor" name="sabox_author_different_description"><?php echo wp_kses_post($author_page_description); ?></textarea>
                    </td>
                </tr>
            </table>

        </div>

<?php
    }

    public function add_pro_defauls($default)
    {

        $default['saboxplugin_options']['sab_position'] = 'bottom';
        $default['saboxplugin_options']['sab_author_link'] = 'author-page';
        $default['saboxplugin_options']['sab_author_link_noffolow'] = '0';
        $default['saboxplugin_options']['sab_tax_visibility'] = array();
        $default['saboxplugin_options']['sab_visibility'] = array('post');
        $default['saboxplugin_options']['sab_color_palette'] = 'none';
        $default['saboxplugin_options']['enable_guest_authors'] = '0';
        $default['saboxplugin_options']['co_authors'] = '0';
        $default['saboxplugin_options']['co_authors_custom'] = '0';
        $default['saboxplugin_options']['sabox_author_different_description'] = '0';
        $default['saboxplugin_options']['co_authors_custom_text'] = '';
        $default['saboxplugin_options']['sab_border_type'] = 'solid';
        $default['saboxplugin_options']['sab_border_color'] = '#eee';
        $default['saboxplugin_options']['sab_border_location'] = array('top', 'bottom', 'left', 'right');
        $default['saboxplugin_options']['sab_hide_brackets'] = '0';
        $default['sabpro_license_key'] = '';
        $default['sab_box_job_font'] = 'None';
        $default['sab_box_job_font_size'] = '12';
        $default['saboxplugin_options']['sab_tab_background_color'] = '#e4e4e4';
        $default['saboxplugin_options']['sab_tab_text_color'] = '#222222';
        $default['saboxplugin_options']['sab_tab_border_color'] = '#c7c7c7';
        $default['saboxplugin_options']['sab_tab_hover_background_color'] = '#efefef';
        $default['saboxplugin_options']['sab_tab_hover_text_color'] = '#222222';
        $default['saboxplugin_options']['sab_tab_hover_border_color'] = '#c7c7c7';

        return $default;
    }
}
