<?php

/**
 *
 */
class Simple_Author_Box_Pro_Helper
{

    public static function get_custom_post_type()
    {
        $posttypes = get_post_types(
            array(
                'publicly_queryable' => true,
                '_builtin'           => false,
            ),
            'objects'
        );

        foreach ($posttypes as $slug => $post_type) {
            $post_types[$slug] = $post_type->label;
        }

        $post_types['post'] = __('Posts', 'simple-author-box');
        $post_types['page'] = __('Pages', 'simple-author-box');


        return $post_types;
    }

    public static function get_taxonomy_types()
    {
        $taxonomies_types = array();
        $taxonomies = get_taxonomies(
            array(
                '_builtin' => false,
                'public'   => true,
            ),
            'objects'
        );

        foreach ($taxonomies as $slug => $taxonomy) {
            $taxonomies_types[$slug] = $taxonomy->label;
        }

        $taxonomies_types['category'] = __('Categories', 'simple-author-box');
        $taxonomies_types['post_tag'] = __('Tags', 'simple-author-box');


        return $taxonomies_types;
    }

    public static function pro_generate_inline_css()
    {
        $options = Simple_Author_Box_Helper::get_option('saboxplugin_options');
        $borders = array('top', 'bottom', 'left', 'right');

        $style            = '.saboxplugin-wrap{';
        $border_style     = (isset($options['sab_border_type'])) ? $options['sab_border_type'] : "";
        $border_color     = (isset($options['sab_box_border'])) ? $options['sab_box_border'] : "";
        $border_positions = (isset($options['sab_border_location'])) ? $options['sab_border_location'] : "";

        if ($border_positions != '0') {
            foreach ($borders as $border) {
                if (is_array($border_positions) && in_array($border, $border_positions)) {
                    $style .= ' border-' . $border . '-style:' . $border_style . ' !important;';
                    $style .= ' border-' . $border . '-color:' . $border_color . ' !important;';
                } else {
                    $style .= ' border-' . $border . '-width:0px !important;';
                }
            }
        } else {
            $style .= ' border-width:0px !important;';
        }

        $style .= '}';
        return apply_filters('sabox_inline_css', $style);
    }

    public static function strip_prot($url)
    {
        $url = str_ireplace("http://", "", $url);
        $url = str_ireplace("https://", "", $url);
        return $url;
    }

    static function whitelabel_filter()
    {
        global $wf_sab_licensing;

        if (empty($wf_sab_licensing)) {
            return true;
        }

        $settings = Simple_Author_Box_Helper::get_option('saboxplugin_options');

        if (!$wf_sab_licensing->is_active('white_label')) {
            return true;
        }

        if ($settings['sab_whitelabel'] != 1) {
            return true;
        }

        return false;
    }

    static function get_rebranding($key = false)
    {
        global $wf_sab_licensing;
        if (empty($wf_sab_licensing)) {
            return false;
        }
        $license = $wf_sab_licensing->get_license();
        if (empty($license) || !is_array($license) || !array_key_exists('meta', $license) || !is_array($license['meta'])) {
            return false;
        }
        if (array_key_exists('rebrand', $license['meta']) && !empty($license['meta']['rebrand'])) {
            if (!empty($key)) {
                return $license['meta']['rebrand'][$key];
            }
            return $license['meta']['rebrand'];
        } else {
            return false;
        }
    }
}
