<?php

if ( is_multisite() ) {
	if ( ! current_user_can( 'create_users' ) && ! current_user_can( 'promote_users' ) ) {
		wp_die(
			'<h1>' . __( 'Cheatin&#8217; uh?', 'saboxpro' ) . '</h1>' .
			'<p>' . __( 'Sorry, you are not allowed to add users to this network.', 'saboxpro' ) . '</p>',
			403
		);
	}
} elseif ( ! current_user_can( 'create_users' ) ) {
	wp_die(
		'<h1>' . __( 'Cheatin&#8217; uh?', 'saboxpro' ) . '</h1>' .
		'<p>' . __( 'Sorry, you are not allowed to create users.', 'saboxpro' ) . '</p>',
		403
	);
}

wp_enqueue_script( 'wp-ajax-response' );
wp_enqueue_script( 'user-profile' );

require_once( ABSPATH . 'wp-admin/admin-header.php' );

if ( isset( $_GET['update'] ) ) {
	$messages = array();
	if ( is_multisite() ) {
		$edit_link = '';
		if ( ( isset( $_GET['user_id'] ) ) ) {
			$user_id_new = absint( $_GET['user_id'] );
			if ( $user_id_new ) {
				$edit_link = esc_url( add_query_arg( 'wp_http_referer', urlencode( wp_unslash( $_SERVER['REQUEST_URI'] ) ), get_edit_user_link( $user_id_new ) ) );
			}
		}

		switch ( $_GET['update'] ) {
			case 'addexisting':
				$messages[] = __( 'That user is already a member of this site.', 'saboxpro' );
				break;
			case 'enter_email':
				$messages[] = __( 'Please enter a valid email address.', 'saboxpro' );
				break;
		}
	}
}

$creating       = isset( $_POST['createguestauthor'] );
$new_user_login = $creating && isset( $_POST['user_login'] ) ? wp_unslash( $_POST['user_login'] ) : '';
$new_user_email = $creating && isset( $_POST['email'] ) ? wp_unslash( $_POST['email'] ) : '';
global $add_user_errors;

?>
<div class="wrap">
	<h1 id="add-new-user"><?php _e( 'Add Guest Author', 'saboxpro' ); ?> </h1>

<?php

if ( is_wp_error( $add_user_errors ) ) {
	echo '<div id="message" class="error"><p>' . $add_user_errors->get_error_message() . '</p></div>';
}

?>

<form method="post" name="adduser" id="adduser" class="validate" novalidate="novalidate" >
<input name="action" type="hidden" value="addguestauthor" />
<input name="role" type="hidden" value="sab-guest-author" />

<?php $pwd = wp_generate_password( 12, false ) ?>
<input name="pass1" type="hidden" value="<?php echo $pwd ?>" />
<input name="pass2" type="hidden" value="<?php echo $pwd ?>" />
<?php wp_nonce_field( 'add-guest-author', '_wpnonce_add-guest-author' ); ?>

<table class="form-table">
	<tr class="form-field form-required">
		<th scope="row"><label for="user_login"><?php _e( 'Username', 'saboxpro' ); ?> <span class="description"><?php _e( '(required)', 'saboxpro' ); ?></span></label></th>
		<td><input name="user_login" type="text" id="user_login" value="<?php echo esc_attr( $new_user_login ); ?>" aria-required="true" autocapitalize="none" autocorrect="off" maxlength="60" /></td>
	</tr>
	<tr class="form-field form-required">
		<th scope="row"><label for="email"><?php _e( 'Email', 'saboxpro' ); ?> <span class="description"><?php _e( '(required)', 'saboxpro' ); ?></span></label></th>
		<td><input name="email" type="email" id="email" value="<?php echo esc_attr( $new_user_email ); ?>" /></td>
	</tr>
</table>
<?php submit_button( __( 'Add Guest Author', 'saboxpro' ), 'primary', 'createguestauthor', true, array( 'id' => 'addusersub' ) ); ?>
</form>
</div>
<?php
