/**
 * SAB
 * (c) Web factory Ltd, 2016 - 2021
 */

(function ($) {
  var context = $("#themes-tab"),
    authorLinkType,
    authorLinkNofollowElement;

  var palette = sabox_admin_pro.themes;

  context.find(".sab-theme-thumbnail").on("click", function () {
    var value = $(this).data("theme"),
      currentPalette = palette[value];
    $("#sab_color_palette").val(value);
    $(".sab-theme-thumbnail").removeClass("active");
    $(this).addClass("active");
    $.each(currentPalette, function (index, value) {
      var id = "#" + index;
      if ($(id).length > 0) {
        switch (index) {
          case "sab_box_author_color":
          case "sab_box_web_color":
          case "sab_box_border":
          case "sab_box_icons_back":
          case "sab_box_icons_color":
          case "sab_tab_background_color":
          case "sab_tab_text_color":
          case "sab_tab_border_color":
          case "sab_tab_hover_background_color":
          case "sab_tab_hover_text_color":
          case "sab_tab_hover_border_color":
            console.log(index,value);
            $(id).wpColorPicker("color", value);
          default:
            $(id).val(value);
            $(id).trigger("change");
        }
      }
    });
  });

  authorLinkNofollowElement = $("#sab_author_link_noffolow");
  authorLinkType = $("#sab_author_link").val();

  if ("author-website" == authorLinkType) {
    authorLinkNofollowElement.parents("tr").show();
  } else {
    authorLinkNofollowElement.parents("tr").hide();
  }

  $(document).ready(function () {
    $("#sab_author_link").change(function () {
      var value = $(this).val();

      if ("author-website" == value) {
        authorLinkNofollowElement.parents("tr").show();
      } else {
        authorLinkNofollowElement.parents("tr").hide();
      }
    });
  });

  var unsplash_page = 1;
  var total_pages = 9999;
  var total_results = 0;
  var unsplash_search_query = "";
  var custom_uploader;

  function sab_get_unsplash_images() {
    jQuery
      .ajax({
        url: ajaxurl,
        method: "POST",
        crossDomain: true,
        dataType: "json",
        timeout: 30000,
        data: {
          action: "sab_editor_unsplash_api",
          page: unsplash_page,
          per_page: 60,
          search: unsplash_search_query,
        },
      })
      .success(function (response) {
        var unsplash_images = "";
        var unsplash_html = "";
        if (response.success) {
          if (response.data.results) {
            unsplash_images = JSON.parse(response.data.results);
            total_results = response.data.total_results;
            total_pages = response.data.total_pages;

            for (i in unsplash_images) {
              unsplash_html += '<div class="sab-unsplash-image" data-id="' + unsplash_images[i]["id"] + '" data-url="' + unsplash_images[i]["full"] + '" data-name="' + unsplash_images[i]["name"] + '">';
              unsplash_html += '<img src="' + unsplash_images[i]["thumb"] + '">';
              unsplash_html += unsplash_images[i]["user"];
              unsplash_html += "</div>";
            }
          }

          unsplash_html += '<div class="sab_unsplash_pagination">';

          if (total_pages > 1) {
            unsplash_html += total_results.toFixed().replace(/(\d)(?=(\d{3})+(,|$))/g, "$1,") + " images";
          }

          if (unsplash_page > 1) {
            unsplash_html += '<div id="sab_unsplash_prev">&lt;- Previous</div>';
          }
          if (!total_pages || unsplash_page < total_pages) {
            unsplash_html += '<div id="sab_unsplash_next">Next -&gt;</div>';
          }
          unsplash_html += "</div>";
          unsplash_html += '<p style="text-align: center;"><small>Powered by <a href="https://unsplash.com/?utm_source=Coming+Soon+demo&utm_medium=referral" target="_blank">Unsplash</a></small></p>';
          jQuery(".unsplash-browser").html(unsplash_html);
        } else {
          jQuery(".unsplash-browser").html('<div class="sab-loader">An error occured contacting the Unsplash API.<br /><span class="sab-unsplash-retry">Click here to try again.</span></div>');
        }
      })
      .error(function (type) {
        jQuery(".unsplash-browser").html('<div class="sab-loader">An error occured contacting the Unsplash API.<br /><span class="sab-unsplash-retry">Click here to try again.</span></div>');
      });
  }

  // upload function

  function getUploader($text, $target, $3rdparty) {
    if (custom_uploader) {
      custom_uploader.detach();
    }

    // Extend the wp.media object
    custom_uploader = wp.media.frames.file_frame = wp.media({
      title: $text,
      button: {
        text: $text,
      },
      multiple: false,
    });

    if ($3rdparty) {
      custom_uploader.on("open", function () {
        var image_input_id = $target.parent().children(".sabox_upload_image_input").attr("id");

        if (!jQuery(".media-frame-router .media-router .sab-unsplash-images").length) {
          jQuery(".media-frame-router .media-router").append('<a href="#" class="media-menu-item sab-unsplash-images">Unsplash (free images)</a>');
        }

        unsplash_search_query = "";

        $(".media-menu-item").removeClass("active");
        $(".sab-unsplash-images").addClass("active");
        custom_uploader.content._mode = "unsplash";
        //mediaUploader.router.view=[];
        $(".media-button-select").hide();
        $(".sab-media-button-select").show();
        $(".media-modal-content .media-frame-content").html('<div class="unsplash_head"><button disabled="disabled" id="unsplash_search_btn" class="button button-primary">Search</button><input type="text" id="unsplash_search" placeholder="Search images..." /></div><div class="unsplash-browser"><div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Loading images ...</div> </div>');

        if (jQuery(".media-toolbar .sab-media-button-select").length) {
          jQuery(".media-toolbar .sab-media-button-select").remove();
        }
        jQuery(".media-button-select").after('<button type="button" disabled="disabled" ' + (jQuery(".media-menu-item.active").hasClass("sab-unsplash-images") ? "" : ' style="display:none" ') + ' class="button button-primary button-large media-button sab-media-button-select" data-id="' + image_input_id + '">Use Selected Image</button>');
        sab_get_unsplash_images(1);
      });
    }

    // When a file is selected, grab the URL and set it as the text field's value
    custom_uploader.on("select", function () {
      var attachment = custom_uploader.state().get("selection").first().toJSON();
      $target.parent().find("input").val(attachment.url);
      $target
        .parents(".sab-element-image-wrapper")
        .find(".sabox-preview-area")
        .html('<img src="' + attachment.url + '" />&nbsp;<a href="javascript: void(0);" class="sab-remove-image">Remove Image</a>');
    });

    // Open the uploader dialog
    custom_uploader.open();
  }

  // WP native uploader

  $(document).on("click", ".sab-image-upload", function (e) {
    e.preventDefault();
    getUploader("Select Image", $(this), true);
  });

  $("body").on("click", ".sab-unsplash-image", function () {
    $(".sab-unsplash-image").removeClass("sab-unsplash-image-selected");
    $(this).addClass("sab-unsplash-image-selected");
    $(".sab-media-button-select").removeAttr("disabled");
  });

  $("body").on("keyup change", "#unsplash_search", function (e) {
    if ($(this).val().length == 0 || $(this).val().length >= 3) {
      $("#unsplash_search_btn").removeAttr("disabled");
      if (e.which == 13) {
        unsplash_execute_search();
      }
    } else {
      $("#unsplash_search_btn").attr("disabled", "disabled");
    }
  });

  $("body").on("click", "#unsplash_search_btn", function () {
    unsplash_execute_search();
  });

  function unsplash_execute_search() {
    if ($("#unsplash_search").val().length == 0 || $("#unsplash_search").val().length >= 3) {
      $(".unsplash-browser").html('<div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Searching images ... </div> ');
      unsplash_search_query = $("#unsplash_search").val();
      unsplash_page = 1;
      sab_get_unsplash_images();
    } else {
      $("#unsplash_search_btn").attr("disabed", "disabled");
    }
  }

  // Removing photo from the canvas and emptying the text field
  $(document).on("click", ".sab-remove-image", function (e) {
    e.preventDefault();
    $(this).parents(".sab-element-image-wrapper").children(".sab-image-picker").find("input").val("");
    $(this).parents(".sab-element-image-wrapper").children(".sab-image-picker").find("input").trigger("change");
    $(this).parents(".sab-element-image-wrapper").children(".sabox-preview-area").html('<span class="sabox-preview-area-placeholder">Select an image from our 400,000+ images gallery, or upload your own</span>');
  });

  $("body").on("click", ".sab-media-button-select", function () {
    $(".sab-media-button-select").attr("disabled", "disabled");
    if ($(".media-menu-item.active").hasClass("sab-unsplash-images")) {
      var sab_unsplash_id = "";
      var image_input_id = $(this).data("id");
      $(".sab-unsplash-image-selected").each(function () {
        sab_unsplash_id = $(this).data("id");
        sab_unsplash_url = $(this).data("url");
        sab_unsplash_name = $(this).data("name");
      });

      if (sab_unsplash_id != "") {
        $(".media-modal-content .media-frame-content").html('<div class="unsplash-browser"><div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Downloading image ... </div> </div>');
        $.ajax({
          url: ajaxurl,
          method: "POST",
          crossDomain: true,
          dataType: "json",
          timeout: 300000,
          data: {
            action: "sab_editor_unsplash_download",
            image_id: sab_unsplash_id,
            image_url: sab_unsplash_url,
            image_name: sab_unsplash_name,
          },
        })
          .success(function (response) {
            if (response.success) {
              if (response.data) {
                $("#" + image_input_id)
                  .parents(".sab-element-image-wrapper")
                  .find(".sabox-preview-area")
                  .html('<img src="' + response.data + '" />&nbsp;<a href="javascript: void(0);" class="sab-remove-image">Remove Image</a>');

                $("#" + image_input_id).val(response.data);
                $("#" + image_input_id).trigger("change");
                custom_uploader.close();
              }
            } else {
              $(".unsplash-browser").html(response.data);
              var message = "An error occured downloading the image.";
              if (response.data) {
                message = response.data;
              }
              $(".unsplash-browser").html('<div class="sab-loader">' + message + '<br /><span class="sab-unsplash-retry">Click here to return to browsing.</span></div>');
            }
          })
          .error(function (type) {
            $(".unsplash-browser").html('<div class="sab-loader">An error occured downloading the image.<br /><span class="sab-unsplash-retry">Click here to return to browsing.</span></div>');
          })
          .always(function (type) {
            $(".sab-media-button-select").removeAttr("disabled");
          });
      }
    }
  });

  $("body").on("click", ".sab-unsplash-retry", function () {
    $(".unsplash-browser").html('<div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Loading images ... </div> ');
    sab_get_unsplash_images();
  });

  $("body").on("click", "#sab_unsplash_prev", function () {
    $(".unsplash-browser").html('<div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Loading images ... </div> ');
    unsplash_page--;
    sab_get_unsplash_images();
  });

  $("body").on("click", "#sab_unsplash_next", function () {
    $(".unsplash-browser").html('<div class="sab-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Loading images ... </div> ');
    unsplash_page++;
    sab_get_unsplash_images();
  });

  $("body").on("click", ".media-frame-router .media-router .media-menu-item", function () {
    if ($(this).hasClass("sab-unsplash-images")) {
      $(".media-menu-item").removeClass("active");
      $(this).addClass("active");
      custom_uploader.content._mode = "unsplash";
      $(".media-button-select").hide();
      $(".sab-media-button-select").show();
      $(".media-modal-content .media-frame-content").html('<div class="unsplash_head"><button disabled="disabled" id="unsplash_search_btn" class="button button-primary">Search</button><input type="text" id="unsplash_search" placeholder="Search unsplash images..." /></div><div class="unsplash-browser"><div class="sab-unsplash-loader"><span class="dashicons dashicons-spin dashicons-update"></span>&nbsp; Loading images ... </div> </div>');

      sab_get_unsplash_images();
    } else {
      $(".media-button-select").show();
      $(".sab-media-button-select").hide();
    }
  });

  if (typeof sabox_admin_pro != "undefined" && sabox_admin_pro.rebranding == false && sabox_admin_pro.whitelabel == true) {
    // open Help Scout Beacon
    $(".appearance_page_simple-author-box").on("click", ".open-beacon", function (e) {
      e.preventDefault();
      Beacon("open");
      return false;
    });

    // init Help Scout beacon
    if (sabox_admin.sab_is_plugin_page) {
      Beacon("config", {
        enableFabAnimation: false,
        display: {},
        contactForm: {},
        labels: {},
      });
      Beacon("prefill", {
        name: "\n\n\n" + sabox_admin_pro.support_name,
        subject: "Simple Author Box PRO in-plugin support",
        email: "",
        text: "\n\n\n" + sabox_admin_pro.support_text,
      });
      Beacon("init", "b165bd88-8fe0-4977-8bcb-2c6489f87fc5");
    }
  }
})(jQuery);
