/**
  * SAB
  * (c) Web factory Ltd, 2016 - 2021
  */

wp.SAB.models = 'undefined' === typeof( wp.SAB.models ) ? {} : wp.SAB.models;
wp.SAB.views = 'undefined' === typeof( wp.SAB.views ) ? {} : wp.SAB.views;

wp.SAB.models.Settings = wp.SAB.models.Settings.extend({
	initialize: function(){
        var model = this;

  		var view = new wp.SAB.views.proSettings({
  			model: this,
  			el: jQuery( '#sabox-container' )
  		});

  		this.set( 'view', view );
    },
});

wp.SAB.views.proSettings = wp.SAB.views.Settings.extend({

	initialize: function( args ) {

		wp.SAB.views.Settings.prototype.initialize.apply(this, [args]);

		// Adjust Author website settings
    	this.listenTo( this.model, 'change:sab_box_job_font_size', this.adjustAuthorJob );
    	this.listenTo( this.model, 'change:sab_box_job_font', this.adjustAuthorJob );

	},

	adjustAuthorJob: function() {
    	var font = wp.SAB.Settings.getAttribute( 'sab_box_job_font' ),
    		size = wp.SAB.Settings.getAttribute( 'sab_box_job_font_size' ),
    		lineHeight = parseInt( size ) + 7;

    	if ( '' == font || 'None' == font ) {
    		font = 'inherit';
    	}else{
    		this.loadGoogleFonts( font );
    	}


    	jQuery( '.saboxplugin-authorname .sabox-job-title' ).css({ 'font-family' : font, 'font-size': size });
    },

	checkGoogleFonts: function() {
    	var authorFont = this.model.getAttribute( 'sab_box_name_font' ),
    		webFont = this.model.getAttribute( 'sab_box_web_font' ),
    		descriptionFont = this.model.getAttribute( 'sab_box_desc_font' ),
    		jobFont = this.model.getAttribute( 'sab_box_job_font' );

    	if (  '' != authorFont && 'None' != authorFont  ) {
    		this.loadGoogleFonts( authorFont );
    	}

    	if (  '' != webFont && 'None' != webFont  ) {
    		this.loadGoogleFonts( webFont );
    	}

    	if (  '' != descriptionFont && 'None' != descriptionFont  ) {
    		this.loadGoogleFonts( descriptionFont );
    	}

    	if (  '' != jobFont && 'None' != jobFont  ) {
    		this.loadGoogleFonts( jobFont );
    	}

    },

});
