<?php

/**
 *
 */
class Simple_Author_Box_Previewer
{

    // These are fields that we need to listen to see if we need to change the preview.
    private $fields = array(
        'sab_email',
        'sab_hide_socials',
        'sab_box_padding_top_bottom',
        'sab_box_padding_left_right',
        'sab_box_border_width',
        'sab_avatar_style',
        'sab_avatar_size',
        'sab_avatar_hover',
        'sab_web',
        'sab_web_position',
        'sab_colored',
        'sab_icons_style',
        'sab_social_hover',
        'sab_box_long_shadow',
        'sab_box_thin_border',
        'sab_box_author_color',
        'sab_box_web_color',
        'sab_box_border',
        'sab_box_icons_back',
        'sab_box_author_back',
        'sab_box_author_p_color',
        'sab_box_author_a_color',
        'sab_box_icons_color',
        'sab_box_name_font',
        'sab_box_web_font',
        'sab_box_desc_font',
        'sab_box_name_size',
        'sab_box_web_size',
        'sab_box_desc_size',
        'sab_box_icon_size',
        'sab_desc_style'
    );

    private $options;

    function __construct()
    {
        // Output Author Box
        add_action('sab_admin_preview', array($this, 'output_author_box'));
        // Enqueue previewer js
        add_action('admin_enqueue_scripts', array($this, 'admin_style_and_scripts'));
    }

    public function admin_style_and_scripts($hook)
    {
        // loaded only on plugin page
        if ((!defined('SIMPLE_AUTHOR_BOX_GUEST_AUTHORS') || SIMPLE_AUTHOR_BOX_GUEST_AUTHORS == true) && 'appearance_page_simple-author-box' == $hook) {

            wp_enqueue_script('sabox-webfont', 'https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js', array(), false, true);
            wp_enqueue_script('sabox-previewer', SIMPLE_AUTHOR_BOX_ASSETS . 'js/sab-preview.js', array(
                'jquery',
                'backbone',
                'sabox-webfont'
            ), false, true);
        }

        $google_fonts = array();

        $themes = Simple_Author_Box_Helper::get_themes();
        foreach ($themes as $tid => $theme) {
            if(!empty($theme['sab_box_name_font']) && !in_array($theme['sab_box_name_font'],$google_fonts)) $google_fonts[] = $theme['sab_box_name_font'];
            if(!empty($theme['sab_box_job_font']) && !in_array($theme['sab_box_job_font'],$google_fonts)) $google_fonts[] = $theme['sab_box_job_font'];
            if(!empty($theme['sab_box_desc_font']) && !in_array($theme['sab_box_desc_font'],$google_fonts)) $google_fonts[] = $theme['sab_box_desc_font'];
        }

        if (!empty($google_fonts)) { // let's check the array's not empty before actually loading; we want to avoid loading 'none' font-familes
            $final_google_fonts = array();

            foreach ($google_fonts as $v) {
                $final_google_fonts[] = $v . ':400,700,400italic,700italic';
            }

            wp_enqueue_style('sab-theme-fonts', '//fonts.googleapis.com/css?family=' . implode('|', $final_google_fonts), array(), null);
        }
    }

    public function output_author_box()
    {
        $this->options = Simple_Author_Box_Helper::get_option('saboxplugin_options');

        echo '<style type="text/css">';
        echo $this->generate_inline_css();
        echo '</style>';

        echo '<div class="saboxplugin-wrap" style="max-width:656px;margin:0 auto;width:100%;">'; // start saboxplugin-wrap div
        if ('1' == $this->options['sab_show_latest_posts'] || '1' == $this->options['sab_show_custom_html']) {
            echo '<div class="saboxplugin-tabs-wrapper">';
            echo '<ul>';
            echo '<li class="active" data-tab="about">' . $this->options['sab_tab_about_title'] . '</li>';
            echo '<li data-tab="latest_posts" ' . ('1' == $this->options['sab_show_latest_posts'] ? '' : 'style="display:none;"') . '>' . $this->options['sab_tab_latest_title'] . '</li>';
            echo '<li data-tab="other" data-tab="latest_posts" ' . ('1' == $this->options['sab_show_custom_html'] ? '' : 'style="display:none;"') . '>' . $this->options['sab_tab_custom_html_title'] . '</li>';
            echo '</div>';
        }

        echo '<div class="saboxplugin-tab saboxplugin-tab-about">';
        // author box gravatar
        $avatar_classes = 'saboxplugin-gravatar';
        if ('1' == $this->options['sab_avatar_hover']) {
            $avatar_classes .= ' sab-rotate-img';
        }

        switch ($this->options['sab_avatar_style']) {
            case '1':
                $avatar_classes .= ' sab-round-image';
                break;
            case '2':
                $avatar_classes .= ' sab-fancy-image';
                break;
            case '3':
                $avatar_classes .= ' sab-elypse-image';
                break;
            case '4':
                $avatar_classes .= ' sab-shear-image';
                break;
            case '5':
                $avatar_classes .= ' sab-speed-image';
                break;
        }

        echo '<div class="' . $avatar_classes . '">';
        echo get_avatar(1, 264, 'mystery', '', array('force_default' => true));

        echo '</div>';

        // author box name
        echo '<div class="saboxplugin-authorname">';
        echo apply_filters('sabox_preview_author_html', '<a href="#" class="vcard author"><span class="fn">John Doe</span></a>');
        echo '</div>';


        // author box description
        echo '<div class="saboxplugin-desc">';
        echo '<div>';
        echo wp_kses_post('Sed non elit aliquam, tempor nisl vitae, euismod quam. Nulla et lacus lectus. Nunc sed tincidunt arcu. Nam maximus luctus nunc, in ullamcorper turpis luctus ac. Morbi a leo ut metus mollis facilisis. Integer feugiat dictum dolor id egestas. Interdum et malesuada fames ac ante ipsum primis in faucibus.');
        echo '</div>';
        echo '</div>';

        echo '<div class="saboxplugin-web' . ('1' == $this->options['sab_web'] ? ' sab-web-position' : '') . '" style="' . ('1' == $this->options['sab_web'] ? '' : 'display:none;') . '">';
        echo '<a href="https://wpauthorbox.com" target="_blank">www.wpauthorbox.com</a>';
        echo '</div>';

        // author box clearfix
        echo '<div class="clearfix"></div>';

        $social_links               = apply_filters('sabox_social_icons', Simple_Author_Box_Helper::$social_icons);
        $social_links['user_email'] = '#';

        $extra_class = ' sab-show-simple';
        if ('1' == $this->options['sab_colored']) {
            if ('1' == $this->options['sab_icons_style']) {
                $extra_class = ' sab-show-circle';
            } else {
                $extra_class = ' sab-show-square';
            }
        }

        if ('1' != $this->options['sab_box_long_shadow']) {
            $extra_class .= ' without-long-shadow';
        }

        if ('1' == $this->options['sab_social_hover']) {
            $extra_class .= ' sab-rotate-icons';
        }

        if ('1' == $this->options['sab_box_thin_border']) {
            $extra_class .= ' sab-icons-with-border';
        }

        echo '<div class="saboxplugin-socials sabox-colored' . $extra_class . '" style="' . ('1' == $this->options['sab_hide_socials'] ? 'display:none;' : '') . '">';
        $simple_icons_html = '';
        $circle_icons_html = '';
        $square_icons_html = '';
        $link              = '<a href="#" class="%s">%s</a>';

        foreach ($social_links as $social_platform => $social_link) {

            $simple_icons_html .= sprintf($link, 'saboxplugin-icon-grey', Simple_Author_Box_Social::icon_to_svg($social_platform, 'simple'));
            $circle_icons_html .= sprintf($link, 'saboxplugin-icon-color', Simple_Author_Box_Social::icon_to_svg($social_platform, 'circle'));
            $square_icons_html .= sprintf($link, 'saboxplugin-icon-color', Simple_Author_Box_Social::icon_to_svg($social_platform, 'square'));
        }

        echo '<div class="sab-simple-icons">' . $simple_icons_html . '</div>';
        echo '<div class="sab-circle-icons">' . $circle_icons_html . '</div>';
        echo '<div class="sab-square-icons">' . $square_icons_html . '</div>';


        echo '</div>';
        echo '</div>'; // about tab

        echo '<div class="saboxplugin-tab saboxplugin-tab-latest_posts" style="display:none">';
        $latest_posts = get_posts(array(
            'author'        =>  get_current_user_id(),
            'orderby'       =>  'post_date',
            'order'         =>  'DESC',
            'posts_per_page' => 3
        ));
        if (!empty($latest_posts)) {
            echo '<ul>';
            foreach ($latest_posts as $post) {
                echo '<li><a href="' . get_permalink($post->ID) . '">';
                //TODO: Show thumbnail?
                /*
                $post_thumbnail = get_the_post_thumbnail_url($post->ID);
                echo '<div class="sab-post-thumbnail">';
                if(!empty($post_thumbnail)){
                    echo '<img src="' . get_the_post_thumbnail_url($post->ID) . '" />';
                } else {
                    echo '<img src="data:image/png;base64,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" />';
                }
                echo '</div>';*/
                echo $post->post_title . '</a></li>';
            }
            echo '</ul>';
        } else {
            echo 'You do not have any posts.';
        }
        echo '</div>';

        echo '<div class="saboxplugin-tab saboxplugin-tab-other" style="display:none">';
        $author_html = get_user_meta(get_current_user_id(), 'sab_box_author_html', true);
        if (!empty($this->options['sab_tab_custom_html_body'])) {
            echo str_ireplace('%%author_html%%', $author_html, $this->options['sab_tab_custom_html_body']);
        } else if (false != $author_html) {
            echo $author_html;
        } else {
            echo '<i>Set your Author Custom HTML Tab Content on your <a href="' . admin_url('profile.php') . '#sabox-custom-job-title" target="_blank" class="clickable">Profile page</a></i>';
        }
        echo '</div>';

        echo '</div>'; // end of saboxplugin-wrap div
        echo '<div class="note">' .  __('<strong>Note:</strong> By default our Author Box will take the current font family and color from your theme. Basically if you don\'t select a font or a color from the plugin\'s settings the font and color of the Author Box will be different on the front-end than in the previewer.', 'simple-author-box') . '</div>';
    }

    private function generate_inline_css()
    {

        $padding_top_bottom = Simple_Author_Box_Helper::get_option('sab_box_padding_top_bottom');
        $padding_left_right = Simple_Author_Box_Helper::get_option('sab_box_padding_left_right');
        $sabox_name_size    = Simple_Author_Box_Helper::get_option('sab_box_name_size');
        $sabox_desc_size    = Simple_Author_Box_Helper::get_option('sab_box_desc_size');
        $sabox_icon_size    = Simple_Author_Box_Helper::get_option('sab_box_icon_size');
        $sabox_options      = Simple_Author_Box_Helper::get_option('saboxplugin_options');
        $sabox_web_size     = Simple_Author_Box_Helper::get_option('sab_box_web_size');
        $sab_avatar_size     = $sabox_options['sab_avatar_size'];

        $style = '.saboxplugin-wrap{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;-ms-box-sizing:border-box;box-sizing:border-box;border:1px solid #eee;width:100%;clear:both;display:block;overflow:hidden;word-wrap:break-word;position:relative}.saboxplugin-wrap .saboxplugin-gravatar{float:left;padding:20px}.saboxplugin-wrap .saboxplugin-gravatar img{max-width:' . $sab_avatar_size . 'px;height:auto;}.saboxplugin-wrap .saboxplugin-authorname{font-size:18px;line-height:1;margin:20px 0 0 20px;display:block}.saboxplugin-wrap .saboxplugin-authorname a{text-decoration:none}.saboxplugin-wrap .saboxplugin-authorname a:focus{outline:0}.saboxplugin-wrap .saboxplugin-desc{display:block;margin:5px 20px}.saboxplugin-wrap .saboxplugin-desc a{text-decoration:underline}.saboxplugin-wrap .saboxplugin-desc p{margin:5px 0 12px}.saboxplugin-wrap .saboxplugin-web{margin:0 20px 15px;text-align:left}.saboxplugin-wrap .sab-web-position{text-align:right}.saboxplugin-wrap .saboxplugin-web a{color:#ccc;text-decoration:none}.saboxplugin-wrap .saboxplugin-socials{position:relative;display:block;background:#fcfcfc;padding:5px;border-top:1px solid #eee}.saboxplugin-wrap .saboxplugin-socials a svg{width:20px;height:20px}.saboxplugin-wrap .saboxplugin-socials a svg .st2{fill:#fff; transform-origin:center center;}.saboxplugin-wrap .saboxplugin-socials a svg .st1{fill:rgba(0,0,0,.3)}.saboxplugin-wrap .saboxplugin-socials a:hover{opacity:.8;-webkit-transition:opacity .4s;-moz-transition:opacity .4s;-o-transition:opacity .4s;transition:opacity .4s;box-shadow:none!important;-webkit-box-shadow:none!important}.saboxplugin-wrap .saboxplugin-socials .saboxplugin-icon-color{box-shadow:none;padding:0;border:0;-webkit-transition:opacity .4s;-moz-transition:opacity .4s;-o-transition:opacity .4s;transition:opacity .4s;display:inline-block;color:#fff;font-size:0;text-decoration:inherit;margin:5px;-webkit-border-radius:0;-moz-border-radius:0;-ms-border-radius:0;-o-border-radius:0;border-radius:0;overflow:hidden}.saboxplugin-wrap .saboxplugin-socials .saboxplugin-icon-grey{text-decoration:inherit;box-shadow:none;position:relative;display:-moz-inline-stack;display:inline-block;vertical-align:middle;zoom:1;margin:10px 5px;color:#444; fill:#444;}.clearfix:after,.clearfix:before{content:\' \';display:table;line-height:0;clear:both}.ie7 .clearfix{zoom:1}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-twitch{border-color:#38245c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-addthis{border-color:#e91c00}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-behance{border-color:#003eb0}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-delicious{border-color:#06c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-deviantart{border-color:#036824}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-digg{border-color:#00327c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-dribbble{border-color:#ba1655}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-facebook{border-color:#1e2e4f}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-flickr{border-color:#003576}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-github{border-color:#264874}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-google{border-color:#0b51c5}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-googleplus{border-color:#96271a}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-html5{border-color:#902e13}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-instagram{border-color:#1630aa}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-linkedin{border-color:#00344f}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-pinterest{border-color:#5b040e}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-reddit{border-color:#992900}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-rss{border-color:#a43b0a}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-sharethis{border-color:#5d8420}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-skype{border-color:#00658a}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-soundcloud{border-color:#995200}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-spotify{border-color:#0f612c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-stackoverflow{border-color:#a95009}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-steam{border-color:#006388}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-user_email{border-color:#b84e05}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-stumbleUpon{border-color:#9b280e}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-tumblr{border-color:#10151b}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-twitter{border-color:#0967a0}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-vimeo{border-color:#0d7091}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-windows{border-color:#003f71}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-wordpress{border-color:#0f3647}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-yahoo{border-color:#14002d}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-youtube{border-color:#900}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-xing{border-color:#000202}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-mixcloud{border-color:#2475a0}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-vk{border-color:#243549}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-medium{border-color:#00452c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-quora{border-color:#420e00}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-meetup{border-color:#9b181c}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-goodreads{border-color:#000}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-snapchat{border-color:#999700}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-500px{border-color:#00557f}.saboxplugin-socials.sabox-colored .saboxplugin-icon-color .sab-mastodont{border-color:#185886} .sab-patreon{border-color:#fc573b} .sabox-plus-item{margin-bottom:20px}@media screen and (max-width:480px){.saboxplugin-wrap{text-align:center}.saboxplugin-wrap .saboxplugin-gravatar{float:none;padding:20px 0;text-align:center;margin:0 auto;display:block}.saboxplugin-wrap .saboxplugin-gravatar img{float:none;display:inline-block;display:-moz-inline-stack;vertical-align:middle;zoom:1}.saboxplugin-wrap .saboxplugin-desc{margin:0 10px 20px;text-align:center}.saboxplugin-wrap .saboxplugin-authorname{text-align:center;margin:10px 0 20px}}body .saboxplugin-authorname a,body .saboxplugin-authorname a:hover{box-shadow:none;-webkit-box-shadow:none}a.sab-profile-edit{font-size:16px!important;line-height:1!important}.sab-edit-settings a,a.sab-profile-edit{color:#0073aa!important;box-shadow:none!important;-webkit-box-shadow:none!important}.sab-edit-settings{margin-right:15px;position:absolute;right:0;z-index:2;bottom:10px;line-height:20px}.sab-edit-settings i{margin-left:5px}.saboxplugin-socials{line-height:1!important}.rtl .saboxplugin-wrap .saboxplugin-gravatar{float:right}.rtl .saboxplugin-wrap .saboxplugin-authorname{display:flex;align-items:center}.rtl .saboxplugin-wrap .saboxplugin-authorname .sab-profile-edit{margin-right:10px}.rtl .sab-edit-settings{right:auto;left:0}img.sab-custom-avatar{max-width:75px;}';

        // Border color of Simple Author Box
        if ('' != $sabox_options['sab_box_border']) {
            $style .= '.saboxplugin-wrap {border-color:' . esc_html($sabox_options['sab_box_border']) . ';}';
            $style .= '.saboxplugin-wrap .saboxplugin-socials {border-color:' . esc_html($sabox_options['sab_box_border']) . ';}';
        }
        // Border width of Simple Author Box
        if ('1' != $sabox_options['sab_box_border_width']) {
            $style .= '.saboxplugin-wrap{ border-width: ' . esc_html($sabox_options['sab_box_border_width']) . 'px; }';
        }
        // Avatar image style
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-round-image img {-webkit-border-radius:50%;-moz-border-radius:50%;-ms-border-radius:50%;-o-border-radius:50%;border-radius:50%;}';
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-fancy-image img {border-radius:16% 84% 18% 82% / 64% 14% 86% 36%;}';
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-elypse-image img {border-radius:70% 30% 67% 33% / 70% 26% 74% 30%; }';
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-shear-image img {border-radius:22% 78% 0% 100% / 54% 52% 48% 46%; }';
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-speed-image img {border-radius:8% 92% 0% 100% / 4% 63% 37% 96%; }';

        // Avatar hover effect
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-rotate-img img {-webkit-transition:all .5s ease;-moz-transition:all .5s ease;-o-transition:all .5s ease;transition:all .5s ease;}';
        $style .= '.saboxplugin-wrap .saboxplugin-gravatar.sab-rotate-img img:hover {-webkit-transform:rotate(45deg);-moz-transform:rotate(45deg);-o-transform:rotate(45deg);-ms-transform:rotate(45deg);transform:rotate(45deg);}';

        // Background color of social icons bar
        if ('' != $sabox_options['sab_box_icons_back']) {
            $style .= '.saboxplugin-wrap .saboxplugin-socials{background-color:' . esc_html($sabox_options['sab_box_icons_back']) . ';}';
        }
        // Background color of author box
        if ('' != $sabox_options['sab_box_author_back']) {
            $style .= '.saboxplugin-wrap {background-color:' . esc_html($sabox_options['sab_box_author_back']) . ';}';
        }
        // Color of author box paragraphs
        if ('' != $sabox_options['sab_box_author_p_color']) {
            $style .= '.saboxplugin-wrap .saboxplugin-desc p, .saboxplugin-wrap .saboxplugin-desc  {color:' . esc_html($sabox_options['sab_box_author_p_color']) . ';}';
        }
        // Color of author box paragraphs
        if ('' != $sabox_options['sab_box_author_a_color']) {
            $style .= '.saboxplugin-wrap .saboxplugin-desc a  {color:' . esc_html($sabox_options['sab_box_author_a_color']) . ';}';
        }

        // Author name color
        if ('' != $sabox_options['sab_box_author_color']) {
            $style .= '.saboxplugin-wrap .saboxplugin-authorname a,.saboxplugin-wrap .saboxplugin-authorname span {color:' . esc_html($sabox_options['sab_box_author_color']) . ';}';
        }

        // Author web color
        if ('1' == $sabox_options['sab_web'] && '' != $sabox_options['sab_box_web_color']) {
            $style .= '.saboxplugin-wrap .saboxplugin-web a {color:' . esc_html($sabox_options['sab_box_web_color']) . ';}';
        }

        // Author name font family
        $sab_box_name_font = Simple_Author_Box_Helper::get_option('sab_box_name_font');
        if ('None' != $sab_box_name_font) {
            $style .= '.saboxplugin-wrap .saboxplugin-authorname {font-family:"' . esc_html($sab_box_name_font) . '";}';
        }

        // Author description font family
        $sab_box_desc_font = Simple_Author_Box_Helper::get_option('sab_box_desc_font');
        if ('None' != $sab_box_name_font) {
            $style .= '.saboxplugin-wrap .saboxplugin-desc {font-family:' . esc_html($sab_box_desc_font) . ';}';
        }

        // Author web font family
        $sab_box_web_font = Simple_Author_Box_Helper::get_option('sab_box_web_font');
        if ('1' == $sabox_options['sab_web'] && 'None' != $sab_box_web_font) {
            $style .= '.saboxplugin-wrap .saboxplugin-web {font-family:"' . esc_html($sab_box_web_font) . '";}';
        }

        // Author description font style
        if (isset($sabox_options['sab_desc_style']) && '1' == $sabox_options['sab_desc_style']) {
            $style .= '.saboxplugin-wrap .saboxplugin-desc {font-style:italic;}';
        }
        // Margin top & bottom, Padding
        $style .= '.saboxplugin-wrap {padding: ' . absint($padding_top_bottom) . 'px ' . absint($padding_left_right) . 'px }';
        // Author name text size
        $style .= '.saboxplugin-wrap .saboxplugin-authorname {font-size:' . absint($sabox_name_size) . 'px; line-height:' . absint($sabox_name_size + 7) . 'px;}';
        // Author description font size
        $style .= '.saboxplugin-wrap .saboxplugin-desc p, .saboxplugin-wrap .saboxplugin-desc {font-size:' . absint($sabox_desc_size) . 'px; line-height:' . absint($sabox_desc_size + 7) . 'px;}';
        // Author website text size
        $style .= '.saboxplugin-wrap .saboxplugin-web {font-size:' . absint($sabox_web_size) . 'px;}';

        // Background
        if (!empty($sabox_options['sab_bg_image'])) {
            $style .= '.saboxplugin-wrap {background-image:url(\'' . $sabox_options['sab_bg_image'] . '\'); background-size:cover;}';
        }

        /* Icons */

        // Color of social icons (for symbols only):
        if ('' != $sabox_options['sab_box_icons_color']) {
            $style .= '.saboxplugin-wrap .saboxplugin-socials .saboxplugin-icon-grey {color:' . esc_html($sabox_options['sab_box_icons_color']) . ';fill:' . esc_html($sabox_options['sab_box_icons_color']) . ';}';
        }

        // Rotate
        $style .= '.saboxplugin-wrap .saboxplugin-socials.sab-show-circle.sab-rotate-icons .saboxplugin-icon-color {-webkit-transition: all 0.3s ease-in-out;-moz-transition: all 0.3s ease-in-out;-o-transition: all 0.3s ease-in-out;-ms-transition: all 0.3s ease-in-out;transition: all 0.3s ease-in-out;}.saboxplugin-wrap .saboxplugin-socials.sab-show-circle.sab-rotate-icons .saboxplugin-icon-color:hover {-webkit-transform: rotate(360deg);-moz-transform: rotate(360deg);-o-transform: rotate(360deg);-ms-transform: rotate(360deg);transform: rotate(360deg);}';

        // Thin border
        $style .= '.saboxplugin-wrap .saboxplugin-socials.sab-icons-with-border .saboxplugin-icon-color svg {border-width: 1px;border-style:solid;}';
        $style .= '.saboxplugin-wrap .saboxplugin-socials.sab-show-circle.sab-icons-with-border .saboxplugin-icon-color svg {border-radius:50%}';

        // Long Shadow
        $style .= '.saboxplugin-wrap .saboxplugin-socials.without-long-shadow .saboxplugin-icon-color .st1 {display: none;}';

        // Icons size
        $icon_size    = absint($sabox_icon_size);
        $icon_size_2x = absint($sabox_icon_size) * 2;

        $style .= '.saboxplugin-wrap .saboxplugin-socials a.saboxplugin-icon-grey svg {width:' . absint($icon_size) . 'px;height:' . absint($icon_size) . 'px;}';
        $style .= '.saboxplugin-wrap .saboxplugin-socials a.saboxplugin-icon-color svg {width:' . absint($icon_size_2x) . 'px;height:' . absint($icon_size_2x) . 'px;}';
        $style .= '.sab-simple-icons,.sab-circle-icons,.sab-square-icons{display:none;}.sab-show-simple .sab-simple-icons{ display:block; }.sab-show-circle .sab-circle-icons{ display:block; }.sab-show-square .sab-square-icons{ display:block; }';
        $style .= '.saboxplugin-wrap a{cursor:not-allowed;}';
        $style .= '.saboxplugin-wrap a.clickable{cursor:pointer;}';

        if(defined('SIMPLE_AUTHOR_BOX_GUEST_AUTHORS')){
            $style .= '.saboxplugin-tabs-wrapper {
                width: 100%;
                display: block;
                clear: both;
                overflow: auto;
            }

            .saboxplugin-tabs-wrapper ul{
                margin:0px;
                padding: 0px;
            }

            .saboxplugin-tabs-wrapper ul li {
                list-style: none;
                float: left;
                color: ' . $sabox_options['sab_tab_text_color'] . ';
                padding: 8px 20px;
                background-color: ' . $sabox_options['sab_tab_background_color'] . ';
                box-sizing: border-box;
                margin-right: 1px;
                border-bottom: 1px solid ' . $sabox_options['sab_tab_border_color'] . ';
            }

            .saboxplugin-tabs-wrapper ul li.active,
            .saboxplugin-tabs-wrapper ul li:hover{
                color: ' . $sabox_options['sab_tab_hover_text_color'] . ';
                background-color: ' . $sabox_options['sab_tab_hover_background_color'] . ';
                border-bottom: 1px solid ' . $sabox_options['sab_tab_hover_border_color'] . ';
                cursor:pointer;
            }

            .saboxplugin-tab{
                padding:20px;
            }

            .saboxplugin-tab ul{
                margin:0px;
                padding: 0px;
            }

            .saboxplugin-tab ul li{
                list-style: none;
            }';
        }

        if (!empty($sabox_options['sab_custom_css'])) {
            $sabox_options['sab_custom_css'];
        }

        if (!empty($sabox_options['sab_hide_theme_author_box'])) {
            $style .= $sabox_options['sab_hide_theme_author_box'] . '{display:none;}';
        }

        $style = apply_filters('sabox-previewer-css', $style, $sabox_options);

        return $style;
    }
}
