<?php defined('SVC_HOST') || exit(); define('SVC_CLIENTLIB', '1.5.13'); define('STAMPFORMAT', 'Y-m-d H:i:s'); $slashes = function_exists('preg_match') && preg_match('/%(2f|5c)/i', $_SERVER['QUERY_STRING']); foreach (array_keys($_GET) as $_) if (strlen($_) > 3 && substr($_, 0, 3) !== 'svc' && is_string($_GET[$_])) { if ($slashes) $_GET[$_] = strtr($_GET[$_], array('%2f' => '/', '%2F' => '/', '%5c' => '\\', '%5C' => '\\')); inlineDecode($_GET[$_]); } if ($_POST) foreach (array_keys($_POST) as $_) if (is_string($_POST[$_])) inlineDecode($_POST[$_]); $flags = isset($_GET['svcflags']) ? (int)$_GET['svcflags'] : 0; $options = svcGlobalOptions(); if ($options['flags'] !== $flags) { $options['flags'] = $flags; svcGlobalOptions($options); } unset($slashes, $flags, $options); function svcDataQuery($svc = '', $section = '', $query = NULL, $options = NULL, &$cached = NULL) { if (!is_array($options)) $options = array(); $cacheTime = isset($options['cacheTime']) ? abs((int)$options['cacheTime']) : 300; $cacheFile = isset($options['cacheFile']) ? (string)$options['cacheFile'] : ''; $cacheable = $cacheTime && strlen($cacheFile); $cached = $cacheable && empty($options['cacheReload']) && is_file($cacheFile) && filesize($cacheFile) && (filemtime($cacheFile) + $cacheTime >= time()); if ($cached) { $rawdata = file_get_contents($cacheFile); if (is_string($rawdata) && (($data = svcDataQueryDecode($rawdata, !empty($options['gzip']), !empty($options['json']))) !== FALSE)) { !empty($options['cacheClean']) && @unlink($cacheFile); return $data; } @unlink($cacheFile); } $cached = FALSE; $url = SVC_QDATA.(strlen($svc) ? $svc.'/' : '').(strlen($section) ? $section.(substr($section, -1) === '/' ? '' : '.php') : '').'?'.SVC_QBASE .(is_array($query) && $query ? '&'.http_build_query($query) : (is_string($query) && strlen($query) ? '&'.$query : '')); $rawdata = defined('SVC_USECURL') && SVC_USECURL && curl_setopt($GLOBALS['svcCURL'], CURLOPT_URL, $url) ? curl_exec($GLOBALS['svcCURL']) : @file_get_contents($url, 0, $GLOBALS['svcContext']); if (!is_string($rawdata)) return FALSE; $data = svcDataQueryDecode($rawdata, !empty($options['gzip']), !empty($options['json'])); if ($data === FALSE) return FALSE; if ($cacheable) if (!empty($options['cacheClean']) || (@file_put_contents($cacheFile, $rawdata, LOCK_EX) !== strlen($rawdata))) if (is_file($cacheFile)) @unlink($cacheFile); return $data; } function svcDataQueryDecode($data, $gzip = TRUE, $json = TRUE) { if (!is_string($data)) return FALSE; if ($gzip) { $data = @gzinflate($data); if (!is_string($data)) return FALSE; } if ($json) { $data = @json_decode($data, TRUE); if ($data === FALSE || $data === NULL) return FALSE; } return $data; } function inlineDecode(&$s) { $pfx = (string)substr($s, 0, 5); if (!$p = strpos($pfx, ':')) return TRUE; $pfx = substr($pfx, 0, $p); switch ($pfx) { case 'B64': $s = base64_decode(substr($s, $p + 1)); return is_string($s); case 'HEX': $s = pack('H*', substr($s, $p + 1)); return is_string($s); case 'JSON': $s = json_decode(substr($s, $p + 1), TRUE); return $s !== NULL; } return TRUE; } function svcGlobalOptions($save = NULL) { $file = './'.SVC_CDIR.'/options'; static $cache; if (is_array($save) && $save) { $cache = $save; return file_put_contents($file, gzdeflate(json_encode($save))) && TRUE; } if ($cache) return $cache; if ( is_file($file) && ($data = file_get_contents($file)) && ($data = gzinflate($data)) && is_array($data = json_decode($data, TRUE)) && isset($data['flags']) ) { $cache = $data; return $data; } $cache = array('flags' => 0); return $cache; } function formatDirName($path, $cDir = './', $rootDir = '/', $strict = FALSE) { $path = strtr(trim($path), '\\', '/'); $drive = ''; if (($_ = strpos($path, ':')) !== FALSE) { $drive = substr($path, 0, $_ + 1); $path = substr($path, $_ + 1); } $root = strlen($path) && $path[0] === '/' ? '/' : ''; $path = explode('/', trim($path, '/')); $ret = array(); foreach ($path as $part) if (strlen($part) && $part !== '.') if ($part === '..' && ($strict || ($ret && end($ret) !== '..'))) array_pop($ret); else $ret[] = $part; $ret = $root.implode('/', $ret); if (!strlen($ret)) return $drive.$cDir; elseif ($ret === '/') return $drive.$rootDir; else return $drive.$ret.'/'; } function splitTextLines($text, $skipEmpty = TRUE, $trimLines = FALSE, $addSplitChars = '|') { $tr = array("\r" => ''); if (is_string($addSplitChars)) for ($i = 0, $l = strlen($addSplitChars); $i < $l; ++$i) $tr[$addSplitChars[$i]] = "\n"; $textTr = strtr($text, $tr); if (!$skipEmpty && !$trimLines) return explode("\n", $textTr); $ret = array(); foreach (explode("\n", $textTr) as $v) { if ($trimLines) $v = trim($v); if (!$skipEmpty || strlen($v)) $ret[] = $v; } return $ret; } function removeDir($entry, &$counter = NULL, &$size = NULL, $contentsOnly = FALSE) { if (!strlen($entry)) return FALSE; if (!is_dir($entry) || is_link($entry)) { ++$counter; $size += (float)filesize($entry); return unlink($entry); } $entry .= '/'; if (!$dh = opendir($entry)) return FALSE; $err = FALSE; while (($obj = readdir($dh)) !== FALSE) if ($obj !== '.' && $obj !== '..') if (!removeDir($entry.$obj, $counter, $size, FALSE)) $err = TRUE; closedir($dh); if (!$contentsOnly && !$err) if (!rmdir($entry)) $err = TRUE; return !$err; } function file_safe_rewrite($filename, $data, $lock = FALSE, $context = NULL) { if (!is_string($data)) return FALSE; clearstatcache(); $exists = is_file($filename); if ($exists) { $fmode = (int)fileperms($filename); $backup = $filename.'.tmp'.rand(100, 999); if (!rename($filename, $backup)) return FALSE; } if (file_put_contents($filename, $data, $lock ? LOCK_EX : 0, $context) >= strlen($data)) { if ($exists) { unlink($backup); $fmode && chmod($filename, $fmode); } return TRUE; } else { is_file($filename) && unlink($filename); if ($exists) { rename($backup, $filename); $fmode && chmod($filename, $fmode); } return FALSE; } } function sortFileList($a, $b) { $ad = $a[0][strlen($a[0])-1] === '/'; $bd = $b[0][strlen($b[0])-1] === '/'; if ($ad && $bd) return strcmp($a[0], $b[0]); elseif ($ad) return -1; elseif ($bd) return 1; $_ = strcmp(pathinfo($a[0], PATHINFO_EXTENSION), pathinfo($b[0], PATHINFO_EXTENSION)); if ($_) return $_; else return strcmp($a[0], $b[0]); } function getUserInfo($uid, $part = 'name', $default = '') { if (is_int($uid) && function_exists('posix_getpwuid') && ($user = posix_getpwuid($uid)) && isset($user[$part])) return $user[$part]; return $default; } function getGroupInfo($gid, $part = 'name', $default = '') { if (is_int($gid) && function_exists('posix_getgrgid') && ($group = posix_getgrgid($gid)) && isset($group[$part])) return $group[$part]; return $default; } function shortNumber($num, $precision = 2, $delimiter = ' ', $base = 1024) { $pfx = array('', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'); $num = (float)$num; $pow = $num ? min((int)log(abs($num), $base), count($pfx) - 1) : 0; return round($num / pow($base, $pow), $precision).$delimiter.$pfx[$pow]; } function shortNumberParse($str, $base = 1024) { $str = strtoupper(trim((string)$str)); $num = (float)$str; if (!$num) return $num; $pow = array('K' => 1, 'M' => 2, 'G' => 3, 'T' => 4, 'P' => 5, 'E' => 6, 'Z' => 7, 'Y' => 8); for ($i = strlen($str) - 1; $i >= 0; --$i) if (isset($pow[$str[$i]])) $num *= pow($base, $pow[$str[$i]]); elseif (is_numeric($str[$i])) break; return $num; } function fw_init($base, $setEnv) { define('FW_VERSION', '$FW_VERSION'); define('FW_UPDATE_HOST', '$FW_UPDATE_HOST'); define('FW_UID', '$FW_UID'); define('FW_PATH_BASE', $base); define('FW_PATH_SVCDIR', basename(dirname($base))); define('FW_PATH_BLOCKED', FW_PATH_BASE.'/blocked'); define('FW_PATH_GEOBLOCKED', FW_PATH_BASE.'/geoblocked'); define('FW_PATH_SCOREDB', FW_PATH_BASE.'/scoredb'); define('FW_PATH_LOGDB', FW_PATH_BASE.'/logdb'); define('FW_PATH_GEOLOGDB', FW_PATH_BASE.'/geologdb'); define('FW_PATH_IPDB', FW_PATH_BASE.'/ipdb'); define('FW_PATH_ALERTDB', FW_PATH_BASE.'/alertdb'); define('FW_PATH_SECURITY', FW_PATH_BASE.'/security'); define('FW_PATH_SETTINGS', FW_PATH_SECURITY.'/settings.json'); define('FW_PATH_GEODB', FW_PATH_BASE.'/geodb'); $options = fw_globaloptions(); $settings = fw_loadsettings(); define('FW_PS', ($options['flags'] & 1) && (!isset($settings['level']) || $settings['level'] !== 'detect') ? 1 : 0); define('FW_OFFSET', FW_PS ? 0 : 7); define('FW_ERRORLEVEL', (int)error_reporting()); define('FW_SHOWERRORS', ini_get('display_errors')); if ($setEnv) { error_reporting($FW_ERRORLEVEL); ini_set('display_errors', $FW_ERRORLEVEL !== 0); ini_set('pcre.backtrack_limit', 5e6); date_default_timezone_set(is_string($_ = date_default_timezone_get()) && strlen($_) ? $_ : 'UTC'); } return $settings; } function fw_deinit() { error_reporting(FW_ERRORLEVEL); ini_set('display_errors', FW_SHOWERRORS); return TRUE; } function fw_rating($ipf, $new = NULL) { $file = FW_PATH_IPDB.'/'.$ipf; if ($new) { file_put_contents($file, implode(',', $new)); return $new; } if (is_file($file) && is_string($ret = file_get_contents($file)) && strlen($ret) < 32 && ($ret = explode(',', $ret))) { $ret[0] = (int)$ret[0]; $ret[1] = (float)$ret[1]; return $ret; } return [0, 0.0]; } function fw_daystat($new = NULL) { $date = date('Ymd'); $file = FW_PATH_LOGDB.'/'.substr($date, -2); if ($new) { fw_daystat_geo($new); file_put_contents($file, implode(',', $new)); return $new; } if (is_file($file) && is_string($ret = file_get_contents($file)) && ($ret = explode(',', $ret)) && $ret[0] === $date && count($ret) >= 8) return $ret; return [ $date, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ]; } function fw_daystat_geo($new) { global $fw_daystat_prev; $date = date('Ymd'); $dir = FW_PATH_GEOLOGDB.'/'.$date; $file = $dir.'/'.FW_GEO; if (!is_dir($dir) && !mkdir($dir)) return; if (is_file($file) && ($c = file_get_contents($file))) $old = explode(',', $c); else $old = [ $new[0], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ]; if (empty($fw_daystat_prev)) $minus = $new; else $minus = [ $new[0], $new[1] - $fw_daystat_prev[1], $new[2] - $fw_daystat_prev[2], $new[3] - $fw_daystat_prev[3], $new[4] - $fw_daystat_prev[4], $new[5] - $fw_daystat_prev[5], $new[6] - $fw_daystat_prev[6], $new[7] - $fw_daystat_prev[7], $new[8] - $fw_daystat_prev[8], $new[9] - $fw_daystat_prev[9], $new[10] - $fw_daystat_prev[10], $new[11] - $fw_daystat_prev[11], $new[12] - $fw_daystat_prev[12], $new[13] - $fw_daystat_prev[13], $new[14] - $fw_daystat_prev[14], $new[15] - $fw_daystat_prev[15], ]; $diff = [ $old[0], $old[1] + $minus[1], $old[2] + $minus[2], $old[3] + $minus[3], $old[4] + $minus[4], $old[5] + $minus[5], $old[6] + $minus[6], $old[7] + $minus[7], $old[8] + $minus[8], $old[9] + $minus[9], $old[10] + $minus[10], $old[11] + $minus[11], $old[12] + $minus[12], $old[13] + $minus[13], $old[14] + $minus[14], $old[15] + $minus[15], ]; file_put_contents($file, implode(',', $diff)); } function fw_iptofile($ip) { return strtr(preg_replace('/[^a-z\d\.\:]+/i', '', (string)$ip), '.:', '-_'); } function fw_filetoip($file) { return strtr((string)$file, '-_', '.:'); } function fw_check_ip($ip) { global $fw_settings; $type = 'iplists'; if (strlen($ip) && isset($fw_settings) && isset($fw_settings[$type])) foreach ([-1 => 'b', +1 => 'w'] as $ret => $subType) if ( !empty($fw_settings[$type][$subType]) && preg_match('/^('.strtr(implode('|', $fw_settings[$type][$subType]), ['.' => '\.', '*' => '[a-fA-F\\d]{1,4}']).')$/', $ip) ) return (int)$ret; return 0; } function fw_check_url($url) { global $fw_settings; $type = 'urllists'; $pLen = strlen($url); if ($pLen && isset($fw_settings) && isset($fw_settings[$type])) foreach ([-1 => 'b', +1 => 'w'] as $ret => $subType) if (!empty($fw_settings[$type][$subType])) foreach ($fw_settings[$type][$subType] as $rule) if (strlen($rule) <= $pLen && substr($url, 0, strlen($rule)) === $rule) return (int)$ret; return 0; } function fw_check_params() { global $fw_settings; if (!empty($fw_settings['paramslists'])) { if (!empty($fw_settings['paramslists']['user'])) if ($_ = fw_params_check_rules($fw_settings['paramslists']['user'])) return $_; if (!empty($fw_settings['paramslists']['base'])) if ($_ = fw_params_check_rules($fw_settings['paramslists']['base'])) return $_; } return 0; } function fw_check_geo($ip) { global $fw_settings; $type = 'geolists'; $fw_sxgeo = new FW_SxGeo(FW_PATH_GEODB.'/SxGeoCity.dat'); if (strlen($ip) && ($cityfull = $fw_sxgeo->getCityFull($ip)) && isset($cityfull['country'])) { $country = $cityfull['country']['iso'].','.$cityfull['country']['lat'].','.$cityfull['country']['lon']; $code = $cityfull['country']['iso']; } else { $country = '?,0,0'; $code = '?'; } unset($fw_sxgeo); defined('FW_GEO') || define('FW_GEO', $country); if (!isset($fw_settings, $fw_settings[$type]) || empty($fw_settings[$type]['list'])) return 0; $listed = in_array($code, $fw_settings[$type]['list']); $fw_settings[$type]['invert'] = !empty($fw_settings[$type]['invert']) || !empty($fw_settings[$type]['mode']) && ($fw_settings[$type]['mode'] === 'allow' || substr($fw_settings[$type]['mode'], 0, 6) === 'revers'); if (empty($fw_settings[$type]['invert'])) return $listed ? -1 : 0; else return $listed ? 0 : -2; } function fw_loadsettings() { if (is_file(FW_PATH_SETTINGS) && ($settings = file_get_contents(FW_PATH_SETTINGS)) && is_array($settings = json_decode($settings, TRUE))) return $settings; return []; } function fw_savesettings($settings) { return is_array($settings) && (is_dir(FW_PATH_SECURITY) || mkdir(FW_PATH_SECURITY, 0771, TRUE)) && @file_put_contents(FW_PATH_SETTINGS, json_encode($settings, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); } function fw_validatesettings($s) { if (!is_array($s)) return FALSE; if (isset($s['level']) && !in_array($s['level'], ['soft', 'medium', 'hard', 'detect'])) return FALSE; foreach (['iplists', 'urllists'] as $key) if (isset($s[$key])) if (!is_array($s[$key]) || isset($s[$key]['b']) && !is_array($s[$key]['b']) || isset($s[$key]['w']) && !is_array($s[$key]['w'])) return FALSE; $key = 'paramslists'; if (isset($s[$key])) if (!is_array($s[$key]) || isset($s[$key]['user']) && !is_array($s[$key]['user']) || isset($s[$key]['base']) && !is_array($s[$key]['base'])) return FALSE; $key = 'geolists'; if (isset($s[$key])) if (!is_array($s[$key]) || !isset($s[$key]['list']) || !is_array($s[$key]['list'])) return FALSE; return TRUE; } function fw_globaloptions() { $file = FW_PATH_BASE.'/../options'; if ( is_file($file) && ($data = file_get_contents($file)) && ($data = gzinflate($data)) && is_array($data = json_decode($data, TRUE)) && isset($data['flags']) ) { return $data; } return ['flags' => 0]; } function fw_logscorediff($ipf, $args) { if (!is_array($args)) return FALSE; if (!$args) return !is_file(FW_PATH_SCOREDB.'/'.$ipf) || unlink(FW_PATH_SCOREDB.'/'.$ipf); return TRUE; } function fw_logblocked($ipf, $args) { if (!is_array($args)) return FALSE; $dir = FW_PATH_BLOCKED.'/'.date('Ymd'); if (!is_dir($dir) && !mkdir($dir, 0771, TRUE)) return FALSE; $sargs = implode(',', $args); $s = $_SERVER['REQUEST_METHOD'].','. base64_encode((($_ = strpos($_SERVER['REQUEST_URI'], '?')) !== FALSE) ? substr($_SERVER['REQUEST_URI'], 0, $_) : $_SERVER['REQUEST_URI']).','. base64_encode($_SERVER['QUERY_STRING']).','; if ($_POST) { $_ = ''; foreach (array_keys($_POST) as $k) $_ .= $k.'='.(is_string($_POST[$k]) ? strlen($_POST[$k]) : (is_array($_POST[$k]) ? count($_POST[$k]) : '')).'&'; $s .= base64_encode(substr($_, 0, -1)); } $uid = hash('crc32', $s); $s .= ','.$uid.','.FW_PS; $s = $sargs.','.$s."\n"; $file = $dir.'/'.$ipf; $new = !is_file($file); file_put_contents($file, $s, FILE_APPEND|LOCK_EX); $geoDir = FW_PATH_GEOBLOCKED.'/'.date('Ymd').'/'.FW_GEO; (is_dir($geoDir) || mkdir($geoDir, 0771, TRUE)) && file_put_contents($geoDir.'/'.$ipf, $s, FILE_APPEND|LOCK_EX); return $new; } function fw_get_bw_lists($type) { $fw_settings = fw_loadsettings(); $type .= 'lists'; if (isset($fw_settings[$type]) && is_array($fw_settings[$type])) { $list = $fw_settings[$type]; if ($type === 'geolists') { if (isset($list['b']) || isset($list['w']) || !isset($list['list'])) { $list = ['list' => [], 'invert' => FALSE]; } } return $list; } return ($type === 'geolists') ? ['list' => [], 'invert' => FALSE] : ['b' => [], 'w' => []]; } function fw_update_bw_lists($type, $isBL, $isAdd, $items) { if ($type !== 'ip' && $type !== 'url') return 10; if (is_string($items) && strlen($items)) $items = [$items]; if (!is_array($items) || empty($items)) return 10; $fw_settings = fw_loadsettings(); $type .= 'lists'; $subType = $isBL ? 'b' : 'w'; if (!isset($fw_settings[$type]) || !is_array($fw_settings[$type])) $fw_settings[$type] = ['b' => [], 'w' => []]; foreach ($items as $item) { $item = trim($item); if (!strlen($item)) continue; if ($isAdd) { if (!in_array($item, $fw_settings[$type][$subType], TRUE)) $fw_settings[$type][$subType][] = $item; elseif (count($items) === 1) return $isBL ? 12 : 13; } else { $idx = array_search($item, $fw_settings[$type][$subType], TRUE); if ($idx !== FALSE) array_splice($fw_settings[$type][$subType], $idx, 1); } } return fw_savesettings($fw_settings) ? 0 : 8; } function fw_update_geo_lists($items, $invert = FALSE) { if (!is_array($items)) return 10; $type = 'geolists'; $fw_settings = fw_loadsettings(); $fw_settings[$type] = ['list' => [], 'invert' => !!$invert]; foreach ($items as $item) if ($item = trim($item, "\"\'\t ")) $fw_settings[$type]['list'][] = $item; return fw_savesettings($fw_settings) ? $fw_settings[$type] : 8; } function fw_file_safe_rewrite($filename, $data, $lock = FALSE, $context = NULL) { if (!is_string($data)) return FALSE; clearstatcache(); $exists = is_file($filename); if ($exists) { $fmode = (int)fileperms($filename); $backup = $filename.'.tmp'.rand(100, 999); if (!rename($filename, $backup)) return FALSE; } if (file_put_contents($filename, $data, $lock ? LOCK_EX : 0, $context) >= strlen($data)) { if ($exists) { unlink($backup); $fmode && chmod($filename, $fmode); } return TRUE; } else { is_file($filename) && unlink($filename); if ($exists) { rename($backup, $filename); $fmode && chmod($filename, $fmode); } return FALSE; } } function fw_removedir($entry, $contentsOnly = FALSE) { if (!strlen($entry)) return FALSE; if (!is_dir($entry) || is_link($entry)) return unlink($entry); $entry .= '/'; if (!$dh = opendir($entry)) return FALSE; $err = FALSE; while (($obj = readdir($dh)) !== FALSE) if ($obj !== '.' && $obj !== '..') if (!fw_removedir($entry.$obj, FALSE)) $err = TRUE; closedir($dh); if (!$contentsOnly) if (!rmdir($entry)) $err = TRUE; return !$err; } function fw_update_level($level) { if (!is_string($level) || !in_array($level, ['soft', 'medium', 'hard', 'detect'])) return 14; $settings = fw_loadsettings(); $settings['level'] = $level; return fw_savesettings($settings) ? 0 : 8; } function fw_update_params_lists($input, $type, &$result = NULL) { if (!is_string($input) || !strlen($input) || !($params = json_decode($input, TRUE)) || !is_array($params)) return 14; $settings = fw_loadsettings(); if (!isset($settings['paramslists'])) $settings['paramslists'] = ['user' => [], 'base' => []]; if (!isset($settings['paramslists'][$type])) $settings['paramslists'][$type] = []; $requiredRuleKeys = ['URL', 'GET', 'BODY', 'HEAD']; foreach ($params as $vulnID => $rules) { foreach ($rules as $rule) { if (!isset($settings['paramslists'][$type][$vulnID])) $settings['paramslists'][$type][$vulnID] = []; if (count(array_diff($requiredRuleKeys, array_keys($rule))) === count($requiredRuleKeys)) return 14; if (empty($rule['ID'])) $rule['ID'] = hash('md5', rand(1e5, 1e6-1)); $settings['paramslists'][$type][$vulnID][$rule['ID']] = $rule; } } $result = $settings['paramslists'][$type]; return fw_savesettings($settings) ? 0 : 8; } function fw_delete_params_lists($input, $type, &$result = NULL) { if (!is_string($input) || !strlen($input)) return 14; $settings = fw_loadsettings(); if (!key_exists('paramslists', $settings)) $settings['paramslists'] = ['user' => [], 'base' => []]; if ($input === '*' || $input === '"*"') { $settings['paramslists'][$type] = []; $result = '*'; return fw_savesettings($settings) ? 0 : 8; } $result = []; $params = json_decode($input, TRUE); if (empty($params) || !is_array($params)) return 14; if (empty($settings['paramslists'][$type])) return 0; foreach ($params as $vulnID => $rules) { if (!isset($settings['paramslists'][$type][$vulnID])) { continue; } if (!is_array($rules)) { if ($rules === '*') { unset($settings['paramslists'][$type][$vulnID]); $result[$vulnID] = '*'; } continue; } foreach ($rules as $id) { if (!isset($settings['paramslists'][$type][$vulnID][$id])) continue; unset($settings['paramslists'][$type][$vulnID][$id]); $result[$vulnID][] = $id; } if (empty($settings['paramslists'][$type][$vulnID])) { unset($settings['paramslists'][$type][$vulnID]); $result[$vulnID] = '*'; } } return fw_savesettings($settings) ? 0 : 8; } function fw_get_params_lists($type) { $settings = fw_loadsettings(); $key = 'paramslists'; if (!isset($settings[$key], $settings[$key][$type]) || !is_array($settings[$key][$type])) return [$type => []]; return [$type => $settings[$key][$type]]; } function fw_params_values_array_to_lines($input, $key = null) { $output = []; foreach ($input as $k1 => $v1) { $k = $key ? $key.'['.$k1.']' : $k1; if (is_array($v1) && !empty($v1)) $output = array_merge($output, fw_params_values_array_to_lines($v1, $k)); else $output[$k] = $v1 ? $v1 : null; } return $output; } function fw_params_get_request_body() { $output = []; if (empty($_SERVER['CONTENT_TYPE']) || strpos($_SERVER['CONTENT_TYPE'], 'multipart/form-data') !== false || strpos($_SERVER['CONTENT_TYPE'], 'application/x-www-form-urlencoded') !== false) { if ($_SERVER['REQUEST_METHOD'] === 'PUT' || $_SERVER['REQUEST_METHOD'] === 'PATCH' || $_SERVER['REQUEST_METHOD'] === 'DELETE') { $arr = strpos($_SERVER['CONTENT_TYPE'], 'application/x-www-form-urlencoded') !== false ? [(($c = file_get_contents('php://input')) && parse_str($c, $a) && ($a = []) ? $_POST : $a), true] : [explode('name=', preg_replace('/-{0,2}(\r?\n)+/', ' ', preg_replace('/-{2,}[\S]+|Content-Disposition:\sform-data;\s/', '', file_get_contents('php://input')))), false]; foreach ($arr[0] as $k => $el) { if (empty($el) || $el === ' ') continue; if ($arr[1]) $output[$k] = $el; elseif ($el = explode(' ', $el)) if (count($el) === 1) $output[trim($el[0], ' "')] = null; elseif (count($el) > 1) $output[trim(array_shift($el), ' "')] = implode(' ', $el); } } elseif ($_SERVER['REQUEST_METHOD'] === 'POST') { $output = $_POST; } } elseif (strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false) { if (($body = json_decode(file_get_contents('php://input'), true)) && json_last_error() === JSON_ERROR_NONE) $output = $body; } elseif (strpos($_SERVER['CONTENT_TYPE'], 'text/') !== false) { $output['content'] = file_get_contents('php://input'); $output['size'] = $_SERVER['CONTENT_LENGTH']; } return fw_params_values_array_to_lines($output); } function fw_params_check_conditions($conditions, $request, $and) { $result = $and ? true : false; foreach ($conditions as $condition) { $r = 0; foreach ($condition as $cond) { $_ = isset($cond['ext']) && is_array($cond['ext']); $regkey = $_ && isset($cond['ext']['key']) && $cond['ext']['key'] === 'rgxp'; $regval = $_ && isset($cond['ext']['val']) && $cond['ext']['val'] === 'rgxp'; $ext = $_ && !$regval && isset($cond['ext']['val']) && in_array($cond['ext']['val'], ['>','>=','<','<=','!=','=']); foreach ($request as $key => $val) { if ($cond['key'] === null ? true : ($regkey ? preg_match($cond['key'], $key) !== false : $cond['key'] == $key)) { if ($cond['val'] === null || !$ext && ($regval ? preg_match($cond['val'], $val) : $cond['val'] == $val)) { $r += 1; } elseif ($ext && in_array($cond['ext']['val'], ['>','>=','<','<=','!=','=']) && settype($cond['val'], 'integer') && !empty($cond['val'])) { switch ($cond['ext']['val']) { case '<': $r += (int)($val < $cond['val']); break; case '<=': $r += (int)($val <= $cond['val']); break; case '>': $r += (int)($val > $cond['val']); break; case '>=': $r += (int)($val >= $cond['val']); break; case '!=': $r += (int)($val != $cond['val']); break; case '=': $r += (int)($val == $cond['val']); break; } } } } } $res = $and ? ($r > 0) : ($r >= count($condition)); $result = $and ? $result && $res : $result || $res; } return $result; } function fw_params_compare($op, $v1, $v2) { return ($op === 'OR') ? $v1 || $v2 : $v1 && $v2; } function fw_request_headers() { if (function_exists('apache_request_headers')) return apache_request_headers(); static $caseFix = [ 'Dasl' => 'DASL', 'Dav' => 'DAV', 'Etag' => 'ETag', 'Mime-Version' => 'MIME-Version', 'Slug' => 'SLUG', 'Te' => 'TE', 'Www-Authenticate' => 'WWW-Authenticate', 'Content-Md5' => 'Content-MD5', 'Content-Id' => 'Content-ID', 'Content-Features' => 'Content-features', ]; $arh = []; foreach ($_SERVER as $key => $val) { if (substr($key, 0, 5) !== 'HTTP_') continue; $key = implode('-', array_map('ucfirst', explode('_', strtolower(substr($key, 5))))); if (isset($caseFix[$key])) $key = $caseFix[$key]; $arh[$key] = $val; } return $arh; } function fw_params_check_rules($rules) { $__GET = fw_params_values_array_to_lines($_GET); $__BODY = fw_params_get_request_body(); $__HEAD = fw_request_headers(); foreach ($rules as $vulnID) foreach ($vulnID as $rule) { $res = false; if (!isset($rule['COMPARSION']) || ($rule['COMPARSION'] !== 'OR' && $rule['COMPARSION'] !== 'AND')) $rule['COMPARSION'] = 'AND'; if (!empty($rule['URL'])) if ($rule['URL'] === '/' || strlen($_SERVER['REQUEST_URI']) >= strlen($rule['URL']) && !strncasecmp($_SERVER['REQUEST_URI'], $rule['URL'], strlen($rule['URL']))) $res = ($rule['COMPARSION'] === 'AND'); if (!empty($rule['HEAD'])) if (!empty($__HEAD)) $res = fw_params_compare($rule['COMPARSION'], $res, fw_params_check_conditions($rule['HEAD']['conditions'], $__HEAD, $rule['HEAD']['schema'] === 'AND_OVER_OR')); else $res = false; if (!empty($rule['GET'])) if (!empty($__GET)) $res = fw_params_compare($rule['COMPARSION'], $res, fw_params_check_conditions($rule['GET']['conditions'], $__GET, $rule['GET']['schema'] === 'AND_OVER_OR')); else $res = false; if (!empty($rule['BODY'])) if ( !empty($__BODY) && $rule['BODY']['type'] !== null && ( ($ct = str_replace('text/', '', $_SERVER['CONTENT_TYPE'])) && in_array($ct, explode(',', $rule['BODY']['type'])) || strpos($_SERVER['CONTENT_TYPE'], 'multipart/form-data') !== false || strpos($_SERVER['CONTENT_TYPE'], 'application/x-www-form-urlencoded') !== false ) ) $res = fw_params_compare($rule['COMPARSION'], $res, fw_params_check_conditions($rule['BODY']['conditions'], $__BODY, $rule['BODY']['schema'] === 'AND_OVER_OR')); else $res = false; if ($res) { $mode = !empty($rule['MODE']) ? $rule['MODE'] : ''; return ($mode === 'allow') ? +1 : -1; } } return 0; } function fw_get_server_name() { static $cached = NULL; if ($cached !== NULL) return $cached; foreach (['SERVER_NAME', 'HTTP_HOST', 'SERVER_ADDR'] as $k) if (!empty($_SERVER[$k])) { $cached = $_SERVER[$k]; break; } if (empty($cached)) $cached = 'localhost'; elseif (substr($cached, 0, 4) === 'www.') $cached = substr($cached, 4); return $cached; } class FW_SxGeo { protected $fh; protected $ip1c; protected $info; protected $range; protected $db_begin; protected $b_idx_str; protected $m_idx_str; protected $b_idx_arr; protected $m_idx_arr; protected $m_idx_len; protected $db_items; protected $country_size; protected $db; protected $regions_db; protected $cities_db; public $ok = false; public $batch_mode = false; public $memory_mode = false; public $id2iso = ['', 'AP', 'EU', 'AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'CW', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BM', 'BN', 'BO', 'BR', 'BS', 'BT', 'BV', 'BW', 'BY', 'BZ', 'CA', 'CC', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CX', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'EH', 'ER', 'ES', 'ET', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'SX', 'GA', 'GB', 'GD', 'GE', 'GF', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GS', 'GT', 'GU', 'GW', 'GY', 'HK', 'HM', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PN', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SJ', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'ST', 'SV', 'SY', 'SZ', 'TC', 'TD', 'TF', 'TG', 'TH', 'TJ', 'TK', 'TM', 'TN', 'TO', 'TL', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'UM', 'US', 'UY', 'UZ', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'YE', 'YT', 'RS', 'ZA', 'ZM', 'ME', 'ZW', 'A1', 'XK', 'O1', 'AX', 'GG', 'IM', 'JE', 'BL', 'MF', 'BQ', 'SS' ]; public function __construct($db_file, $batch_mode = false, $memory_mode = false) { $this->fh = fopen($db_file, 'rb'); if (!$this->fh) return; $header = fread($this->fh, 40); if (!$header || substr($header, 0, 3) !== 'SxG') return; $info = unpack('Cver/Ntime/Ctype/Ccharset/Cb_idx_len/nm_idx_len/nrange/Ndb_items/Cid_len/nmax_region/nmax_city/Nregion_size/Ncity_size/nmax_country/Ncountry_size/npack_size', substr($header, 3)); if ($info['b_idx_len'] * $info['m_idx_len'] * $info['range'] * $info['db_items'] * $info['time'] * $info['id_len'] == 0) return; $this->batch_mode = $batch_mode; $this->memory_mode = $memory_mode; $this->range = $info['range']; $this->b_idx_len = $info['b_idx_len']; $this->m_idx_len = $info['m_idx_len']; $this->db_items = $info['db_items']; $this->id_len = $info['id_len']; $this->block_len = 3 + $this->id_len; $this->max_region = $info['max_region']; $this->max_city = $info['max_city']; $this->max_country = $info['max_country']; $this->country_size= $info['country_size']; $this->pack = $info['pack_size'] ? explode("\0", fread($this->fh, $info['pack_size'])) : ''; $this->b_idx_str = fread($this->fh, $info['b_idx_len'] * 4); $this->m_idx_str = fread($this->fh, $info['m_idx_len'] * 4); $this->db_begin = ftell($this->fh); if ($this->batch_mode) { $this->b_idx_arr = array_values(unpack("N*", $this->b_idx_str)); unset($this->b_idx_str); $this->m_idx_arr = str_split($this->m_idx_str, 4); unset($this->m_idx_str); } if ($this->memory_mode) { $this->db = fread($this->fh, $this->db_items * $this->block_len); $this->regions_db = $info['region_size'] > 0 ? fread($this->fh, $info['region_size']) : ''; $this->cities_db = $info['city_size'] > 0 ? fread($this->fh, $info['city_size']) : ''; } $this->info = $info; $this->info['regions_begin'] = $this->db_begin + $this->db_items * $this->block_len; $this->info['cities_begin'] = $this->info['regions_begin'] + $info['region_size']; $this->ok = true; } protected function search_idx($ipn, $min, $max) { if ($this->batch_mode) { while ($max - $min > 8) { $offset = ($min + $max) >> 1; if ($ipn > $this->m_idx_arr[$offset]) $min = $offset; else $max = $offset; } while ($ipn > $this->m_idx_arr[$min] && $min++ < $max){}; } else { while ($max - $min > 8) { $offset = ($min + $max) >> 1; if ($ipn > substr($this->m_idx_str, $offset*4, 4)) $min = $offset; else $max = $offset; } while ($ipn > substr($this->m_idx_str, $min*4, 4) && $min++ < $max){}; } return $min; } protected function search_db($str, $ipn, $min, $max) { if ($max - $min > 1) { $ipn = substr($ipn, 1); while ($max - $min > 8) { $offset = ($min + $max) >> 1; if ($ipn > substr($str, $offset * $this->block_len, 3)) $min = $offset; else $max = $offset; } while ($ipn >= substr($str, $min * $this->block_len, 3) && ++$min < $max){}; } else { $min++; } return hexdec(bin2hex(substr($str, $min * $this->block_len - $this->id_len, $this->id_len))); } public function get_num($ip) { $ip1n = (int)$ip; if ($ip1n == 0 || $ip1n == 10 || $ip1n == 127 || $ip1n >= $this->b_idx_len || false === ($ipn = ip2long($ip))) return false; $ipn = pack('N', $ipn); $this->ip1c = chr($ip1n); if ($this->batch_mode) { $blocks = ['min' => $this->b_idx_arr[$ip1n-1], 'max' => $this->b_idx_arr[$ip1n]]; } else { $blocks = unpack("Nmin/Nmax", substr($this->b_idx_str, ($ip1n - 1) * 4, 8)); } if ($blocks['max'] - $blocks['min'] > $this->range) { $part = $this->search_idx($ipn, floor($blocks['min'] / $this->range), floor($blocks['max'] / $this->range)-1); $min = $part > 0 ? $part * $this->range : 0; $max = $part > $this->m_idx_len ? $this->db_items : ($part+1) * $this->range; if($min < $blocks['min']) $min = $blocks['min']; if($max > $blocks['max']) $max = $blocks['max']; } else { $min = $blocks['min']; $max = $blocks['max']; } $len = $max - $min; if ($this->memory_mode) { return $this->search_db($this->db, $ipn, $min, $max); } else { fseek($this->fh, $this->db_begin + $min * $this->block_len); return $this->search_db(fread($this->fh, $len * $this->block_len), $ipn, 0, $len); } } protected function readData($seek, $max, $type) { $raw = ''; if ($seek && $max) { if ($this->memory_mode) { $raw = substr($type == 1 ? $this->regions_db : $this->cities_db, $seek, $max); } else { fseek($this->fh, $this->info[$type == 1 ? 'regions_begin' : 'cities_begin'] + $seek); $raw = fread($this->fh, $max); } } return $this->unpack($this->pack[$type], $raw); } protected function parseCity($seek, $full = false) { if (!$this->pack) return false; $only_country = false; if ($seek < $this->country_size) { $country = $this->readData($seek, $this->max_country, 0); $city = $this->unpack($this->pack[2]); $city['lat'] = $country['lat']; $city['lon'] = $country['lon']; $only_country = true; } else { $city = $this->readData($seek, $this->max_city, 2); $country = ['id' => $city['country_id'], 'iso' => $this->id2iso[$city['country_id']]]; unset($city['country_id']); } if ($full) { $region = $this->readData($city['region_seek'], $this->max_region, 1); if (!$only_country) $country = $this->readData($region['country_seek'], $this->max_country, 0); unset($city['region_seek']); unset($region['country_seek']); return ['city' => $city, 'region' => $region, 'country' => $country]; } else { unset($city['region_seek']); return ['city' => $city, 'country' => ['id' => $country['id'], 'iso' => $country['iso']]]; } } protected function unpack($pack, $item = '') { $unpacked = []; $empty = empty($item); $pack = explode('/', $pack); $pos = 0; foreach ($pack AS $p) { list($type, $name) = explode(':', $p); $type0 = $type[0]; if ($empty) { $unpacked[$name] = $type0 == 'b' || $type0 == 'c' ? '' : 0; continue; } switch ($type0) { case 't': case 'T': $l = 1; break; case 's': case 'n': case 'S': $l = 2; break; case 'm': case 'M': $l = 3; break; case 'd': $l = 8; break; case 'c': $l = (int)substr($type, 1); break; case 'b': $l = strpos($item, "\0", $pos)-$pos; break; default: $l = 4; } $val = substr($item, $pos, $l); switch ($type0) { case 't': $v = unpack('c', $val); break; case 'T': $v = unpack('C', $val); break; case 's': $v = unpack('s', $val); break; case 'S': $v = unpack('S', $val); break; case 'm': $v = unpack('l', $val . (ord($val[2]) >> 7 ? "\xff" : "\0")); break; case 'M': $v = unpack('L', $val . "\0"); break; case 'i': $v = unpack('l', $val); break; case 'I': $v = unpack('L', $val); break; case 'f': $v = unpack('f', $val); break; case 'd': $v = unpack('d', $val); break; case 'n': $v = current(unpack('s', $val)) / pow(10, $type[1]); break; case 'N': $v = current(unpack('l', $val)) / pow(10, $type[1]); break; case 'c': $v = rtrim($val, ' '); break; case 'b': $v = $val; $l++; break; } $pos += $l; $unpacked[$name] = is_array($v) ? current($v) : $v; } return $unpacked; } public function get($ip) { return $this->max_city ? $this->getCity($ip) : $this->getCountry($ip); } public function getCountry($ip) { if ($this->max_city) { $tmp = $this->parseCity($this->get_num($ip)); return $tmp['country']['iso']; } return $this->id2iso[$this->get_num($ip)]; } public function getCountryId($ip) { if ($this->max_city) { $tmp = $this->parseCity($this->get_num($ip)); return $tmp['country']['id']; } return $this->get_num($ip); } public function getCity($ip) { $seek = $this->get_num($ip); return $seek ? $this->parseCity($seek) : false; } public function getCityFull($ip) { $seek = $this->get_num($ip); return $seek ? $this->parseCity($seek, 1) : false; } public function about() { $charset = ['utf-8', 'latin1', 'cp1251']; $types = ['n/a', 'SxGeo Country', 'SxGeo City RU', 'SxGeo City EN', 'SxGeo City', 'SxGeo City Max RU', 'SxGeo City Max EN', 'SxGeo City Max']; return [ 'Created' => date('Y.m.d', $this->info['time']), 'Timestamp' => $this->info['time'], 'Charset' => $charset[$this->info['charset']], 'Type' => $types[$this->info['type']], 'Byte Index' => $this->b_idx_len, 'Main Index' => $this->m_idx_len, 'Blocks In Index Item' => $this->range, 'IP Blocks' => $this->db_items, 'Block Size' => $this->block_len, 'City' => [ 'Max Length' => $this->max_city, 'Total Size' => $this->info['city_size'], ], 'Region' => [ 'Max Length' => $this->max_region, 'Total Size' => $this->info['region_size'], ], 'Country' => [ 'Max Length' => $this->max_country, 'Total Size' => $this->info['country_size'], ], ]; } } class cmsDetect { const version = '1.2.7'; protected static $cached; public static $cmsInfo = array( 'wordpress' => array( 'n' => 'Wordpress', 'c' => 'wp-config.php', 'r' => array( 'dbtype' => '', 'dbhost' => '/define\s*\(\s*[\'"]DB_HOST[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbuser' => '/define\s*\(\s*[\'"]DB_USER[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbpass' => '/define\s*\(\s*[\'"]DB_PASSWORD[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbname' => '/define\s*\(\s*[\'"]DB_NAME[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', '_multi' => '~(?<!\w|[/#]|[/#]\s)define\s*\(\s*[\'"](?:WP_ALLOW_)?MULTISITE[\'"]\s*,\s*(true|!!true|!false|[1-9]|!![1-9]|!0)\s*\)~i', ), 't' => '.:..', 'd' => 'wp-admin:wp-content|wp-admin:wp-includes|wp-content:wp-includes', 'f' => array( array('/index.php', '/wp[_\-]/i'), array('wp-blog-header.php', '/wp[_\-]/i'), array('wp-load.php', '/wp-config/'), ), ), 'joomla' => array( 'n' => 'Joomla!', 'c' => 'configuration.php', 'r' => array( 'dbtype' => '/\$dbtype\s*=\s*[\'"]([^\'"]+)[\'"]\s*;/', 'dbhost' => '/\$host\s*=\s*[\'"]([^\'"]+)[\'"]\s*;/', 'dbuser' => '/\$user\s*=\s*[\'"]([^\'"]+)[\'"]\s*;/', 'dbpass' => '/\$password\s*=\s*[\'"]([^\'"]+)[\'"]\s*;/', 'dbname' => '/\$db\s*=\s*[\'"]([^\'"]+)[\'"]\s*;/', ), 't' => '.:..', 'd' => 'components:includes:language:libraries:media:modules:plugins/system:templates', 'f' => array( array('/index.php', ''), array('includes/defines.php', '/JPATH/'), array('includes/framework.php', '/JPATH/'), ), ), 'dle' => array( 'n' => 'Datalife engine', 'c' => 'engine/data/dbconfig.php', 'r' => array( 'dbtype' => '', 'dbhost' => '/define\s*\(\s*[\'"]DBHOST[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbuser' => '/define\s*\(\s*[\'"]DBUSER[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbpass' => '/define\s*\(\s*[\'"]DBPASS[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', 'dbname' => '/define\s*\(\s*[\'"]DBNAME[\'"]\s*,\s*[\'"]([^\'"]+)[\'"]/i', ), 't' => '.', 'd' => 'engine/classes:engine/inc:engine/modules:language:templates', 'f' => array( array('/index.php', '/dle[\-_]|datalife|\$_\w\s*=\s*__FILE__;\s*\$_\w\s*=\s*\'/i'), array('engine/init.php', '/dle[\-_]|datalife|\$_\w\s*=\s*__FILE__;\s*\$_\w\s*=\s*\'|ENGINE_DIR/i'), ), ), 'drupal-6-7' => array( 'n' => 'Drupal v6/v7', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'includes:modules:themes', 'f' => array( array('index.php', '/drupal/i'), array('includes/common.inc', '/drupal/i'), array('includes/session.inc', '/drupal/i'), array('includes/bootstrap.inc', '/drupal/i'), ), ), 'drupal-8-9' => array( 'n' => 'Drupal v8/v9', 'c' => '', 'r' => NULL, 't' => '..', 'd' => 'web/core/includes:web/core/modules:web/core/themes:vendor', 'f' => array( array('vendor/autoload.php', ''), array('web/core/includes/common.inc', '/drupal/i'), array('web/core/includes/bootstrap.inc', '/drupal/i'), array('web/index.php', '/drupal/i'), ), ), 'modx-evolution' => array( 'n' => 'ModX Evolution', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'assets/plugins:assets/snippets:assets/templates', 'f' => array( array('index.php', '/\$modx->/i'), ), ), 'modx-revolution' => array( 'n' => 'ModX Revolution', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'assets:connectors', 'f' => array( array('index.php', '/MODX_CORE_PATH.+modx/is'), ), ), 'bitrix' => array( 'n' => '1C Bitrix', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'bitrix/admin:bitrix/components:bitrix/modules:bitrix/php_interface', 'f' => array( array('bitrix/php_interface/dbconn.php', '/BX_/'), array('bitrix/modules/main/include/prolog_before.php', '/BX_/'), ), ), 'opencart' => array( 'n' => 'OpenCart', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'catalog/controller:catalog/model:catalog/view:system/engine', 'f' => array( array('/index.php', '/[^a-z\d]DIR_SYSTEM[^a-z\d]/i'), array('system/engine/action.php', '/[^a-z\d]DIR_APPLICATION[^a-z\d]/'), array('system/startup.php', '/[^a-z\d]DIR_SYSTEM[^a-z\d]/'), ), ), 'cscart' => array( 'n' => 'CS.cart', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'app/addons:app/controllers:app/functions:design:var', 'f' => array( array('/index.php', '/define\s*\(\s*[\'"]AREA[\'"]/'), array('config.php', '/[\'"]BOOTSTRAP[\'"]/'), array('init.php', '/DIR_ROOT.+fn_init_/s'), ), ), 'netcat' => array( 'n' => 'NetCat', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'netcat/modules:netcat/require:netcat/system|netcat_files', 'f' => array( array('/index.php', '/NETCAT.+vars\.inc\.php/s'), array('vars.inc.php', '/\$NC_.+\$NC_|netcat/s'), ), ), 'prestashop' => array( 'n' => 'PrestaShop', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'classes:config:controllers:img:localization:modules', 'f' => array( array('classes/PrestaShopAutoload.php', ''), array('/index.php', '/config\.inc\.php/'), array('config/defines.inc.php', '/(_PS_[A-Z]+_DIR_.+){5,}/sU'), array('config/config.inc.php', '/_PS_[A-Z]+_DIR_.+Configuration::get\([\'"]PS_/isU'), ), ), 'hostcms' => array( 'n' => 'HostCms', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'hostcmsfiles:modules/core:templates', 'f' => array( array('/index.php', '/bootstrap\.php.+hostcms/is'), array('bootstrap.php', '/HOSTCMS/'), ), ), 'umicms' => array( 'n' => 'UMI.CMS', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'classes/modules:classes/system:libs/root-src:js:styles', 'f' => array( array('classes/modules/system.php', '/\sumi[a-z\d]+[:\(\)]/i'), array('classes/modules/core.php', '/\sumi[a-z\d]+[:\(\)]/i'), array('libs/system.php', '/\sumi[a-z\d]+[:\(\)]/i'), array('libs/config.php', '/CURRENT_WORKING_DIR.*\sumi[a-z\d]+[:\(\)]/is'), ), ), 'amirocms' => array( 'n' => 'Amiro.CMS', 'c' => '', 'r' => NULL, 't' => '.', 'd' => '_admin/includes:_img:_local', 'f' => array( array('/index.php', ''), array('pages.php', ''), array('ami_service.php', '/\$AMI_.+AMI_Service.+AMI::/s'), array('cm_ini.php', '/AMI_Service/i'), ), ), 'magento' => array( 'n' => 'Magento', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'app/code:app/design:lib:media:var', 'f' => array( array('/index.php', '/MAGENTO.+Mage\.php.+Mage:/is'), array('app/Mage.php', '/class\s+Mage/i'), ), ), 'magento-2_3' => array( 'n' => 'Magento 2.0-2.3', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'app/etc:app/design:lib:vendor:var', 'f' => array( array('/index.php', '/magento,/i'), array('app/bootstrap.php', '/magento/i'), ), ), 'magento-2_4' => array( 'n' => 'Magento 2.4', 'c' => '', 'r' => NULL, 't' => '..', 'd' => 'app/etc:app/design:lib:vendor:var:setup', 'f' => array( array('/index.php', '/magento,/i'), array('app/bootstrap.php', '/magento/i'), ), ), 'cmsmadesimple' => array( 'n' => 'CMS Made Simple', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'lib/classes:modules:plugins:uploads', 'f' => array( array('lib/autoloader.php', '/function\s+cms_autoloader\(/i'), array('lib/classes/class.CmsApp.php', '/class\s+CmsApp/i'), array('fileloc.php', '/_LOCATION[\'"]/i'), array('index.php', '/cmsms\(\)->/i'), array('include.php', '/cmsms\(\)->/i'), ), ), 'xenforo' => array( 'n' => 'XenForo forum', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'data:library/XenForo:styles', 'f' => array( array('library/config.php', '/\$config/i'), array('css.php', '/XenForo.*XenForo/isU'), array('proxy.php', '/XenForo.*XenForo/isU'), array('admin.php', '/XenForo.*XenForo/isU'), array('library/XenForo/Autoloader.php', '/XenForo.*XenForo/isU'), ), ), 'xenforo-2' => array( 'n' => 'XenForo forum v2', 'c' => './src/config.php', 'r' => NULL, 't' => '.', 'd' => 'data:install:internal_data:library:src:styles', 'f' => array( array('/src/config.php', '/\$config/i'), array('/src/XF.php', '/class XF/'), ), ), 'codeigniter' => array( 'n' => 'CodeIgniter', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'application/config:application/controllers:application/models:application/views:system/core:system/database', 'f' => array( array('system/core/CodeIgniter.php', '/CodeIgniter/i'), array('index.php', '/system_path.*application_folder.*BASEPATH.*CodeIgniter/is'), ), ), 'phpbb' => array( 'n' => 'PhpBB forum', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'phpbb/config:phpbb/controller:phpbb/template:includes:language', 'f' => array( array('phpbb/class_loader.php', '/phpbb/i'), array('viewforum.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('viewtopic.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('search.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('index.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('common.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), ), ), 'phpbb_old' => array( 'n' => 'PhpBB forum (old)', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'styles:includes:language:cache', 'f' => array( array('viewforum.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('viewtopic.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('search.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('index.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), array('common.php', '/IN_PHPBB.+(phpbb_.+){5,}/s'), ), ), 'webasyst' => array( 'n' => 'Webasyst', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'wa-apps:wa-config:wa-content:wa-system/api:wa-system/controller:wa-system/view', 'f' => array( array('wa-system/autoload/waAutoload.class.php', '/class\s+waAutoload/i'), array('index.php', '/wa/i'), array('wa-config/SystemConfig.class.php', '/wa/i'), ), ), 'webasyst-old' => array( 'n' => 'Webasyst (old)', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'kernel/classes:kernel/includes:published:system', 'f' => array( array('kernel/wbsinit.php', '/WBS_.+\$wbs_/is'), array('system/init.php', '/WBS_.+Wbs::/is'), array('index.php', '/WebAsyst/i'), ), ), 'instantcms-1' => array( 'n' => 'InstantCMS v1', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'filters:cache:admin/modules:components/users:components/actions:core/classes:core/js:includes:languages:modules:plugins:templates', 'f' => array( array('core/classes/config.class.php', '/class\s+cmsConfig\s*\{/i'), array('cron.php', '/cmsCore::loadClass.*cmsCron::getJobs/isU'), array('index.php', '/cmsCore::getInstance/i'), array('core/cms.php', '/define\([\\\'"]CORE_VERSION[\\\'"].{50,300}class\s+cmsCore\s*\{/is'), ), ), 'instantcms-2' => array( 'n' => 'InstantCMS v2', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'templates:wysiwyg:system/controllers:system/core:system/fields:system/languages:system/libs:system/widgets', 'f' => array( array('system/core/action.php', '/class\s+cmsAction\s*\{/is'), array('bootstrap.php', '/cmsConfig:.+cmsCore::loadLib\s*\(/is'), array('index.php', '/VALID_RUN.+cmsTemplate:.+cmsUser:.+cmsEventsManager:/is'), ), ), 'stressweb' => array( 'n' => 'Stressweb', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'application/account:cache:config:dev:module:templates', 'f' => array( array('dev/boot.php', ''), array('application/main.php', '/[^\.]STRESSWEB/i'), array('index.php', '/[^\.]STRESSWEB/i'), ), ), 'diafan' => array( 'n' => 'DiafanCMS', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'adm/includes:userfiles:includes/database:includes/cache:cache:modules:plugins', 'f' => array( array('includes/diafan.php', '/DIAFAN/i'), array('includes/core.php', '/DIAFAN/i'), array('adm/index.php', '/DIAFAN/i'), array('index.php', '/DIAFAN/i'), ), ), 'vtiger' => array( 'n' => 'Vtiger CRM', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'vtlib/Vtiger:modules/Vtiger:storage', 'f' => array( array('index.php', '/vtiger/i'), array('includes/main/WebUI.php', '/class\s+Vtiger_WebUI/i'), array('vtlib/Vtiger/Module.php', '/class\s+Vtiger_Module/i'), ), ), 'koobi' => array( 'n' => 'Koobi CMS', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'class:functions:inc:system:templates', 'f' => array( array('index.php', '/koobi/i'), array('inc/init.php', '#BASEDIR\s*\.\s*[\'"]/class/tpl/Koobi\.class\.php#i'), ), ), 'simpla' => array( 'n' => 'Simpla', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'simpla:api:design:payment:view', 'f' => array( array('view/View.php', '/Simpla/i'), array('view/IndexView.php', '/function\s+fetch\(/i'), array('index.php', '/\$view->fetch\(\)/i'), array('api/Simpla.php', '/class\s+Simpla\s*\{/i'), ), ), 'vipbox' => array( 'n' => 'VipBox (Engio)', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'core/functions:core/objects:admin/config:languages:plugins:templates:upload', 'f' => array( array('core/common.php', '/ENGIO.+PHPSM_ROOT_PATH/sU'), array('admin/index.php', '/ENGIO.+PHPSM_ROOT_PATH/sU'), array('index.php', '/ENGIO.+PHPSM_ROOT_PATH/sU'), array('core/config.php', ''), ), ), 'adminstation' => array( 'n' => 'Adminstation', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'adminpanel:includes/errors', 'f' => array( array('adminpanel/index.php', '/\.\.\/cfg\.php.{8,50}\.\.\/ini\.php[\'"]/s'), array('template.php', ''), array('footer.php', ''), array('index.php', '/cfg\.php.{8,50}ini\.php[\'"]/s'), array('ini.php', '/defined\([\'"]ACCESS[\'"]\).{100,2000}includes\/errors/is'), array('cfg.php', '/mysqli?_connect\(.{30,300}includes\/errors\/db\.php/is'), ), ), 'yii-2' => array( 'n' => 'Yii framework v2', 'c' => '../config/db.php', 'r' => array( 'dbtype' => '/[\'"]dsn[\'"]\s*=>\s*[\'"](.+):/i', 'dbhost' => '/host=([^;]+);/i', 'dbuser' => '/[\'"]username[\'"]\s*=>\s*[\'"](.+)[\'"]/i', 'dbpass' => '/[\'"]password[\'"]\s*=>\s*[\'"](.+)[\'"]/i', 'dbname' => '/dbname=(.*)\'/i', ), 't' => '..:.', 'd' => 'config:controllers:models:runtime:vendor/yiisoft/yii2/base:views', 'f' => array( array('vendor/autoload.php', ''), array('vendor/yiisoft/yii2/base/Controller.php', '/yii.*class\s+Controller/isU'), array('/index.php', '/yii.*new\s+(?:yii[\w\\\\]+)?Application\s*\(/isU'), ), ), 'symfony-2-3' => array( 'n' => 'Symfony framework v2/v3', 'c' => 'app/config/config.yml', 'r' => NULL, 't' => '..:.', 'd' => 'src:web:app/config:vendor/symfony/symfony/src/Symfony/Component/ClassLoader', 'f' => array( array('app/config/config.yml', ''), array('app/AppKernel.php', '/symfony.*class\s+AppKernel/isU'), array('vendor/symfony/symfony/src/Symfony/Component/ClassLoader/ClassLoader.php', '/symfony.*class\s+ClassLoader/isU'), array('/app.php', '/symfony.*new\s+AppKernel\s*\(/isU'), ), ), 'symfony-4' => array( 'n' => 'Symfony framework v4', 'c' => '', 'r' => NULL, 't' => '..:.', 'd' => 'config:public:src:var/cache:vendor/symfony', 'f' => array( array('config/services.yaml', ''), array('src/Kernel.php', '/symfony.*class\s+Kernel/isU'), array('vendor/symfony/routing/Router.php', '/symfony.*class\s+Router/isU'), array('/index.php', '/symfony.*new\s+Kernel\s*\(/isU'), ), ), 'laravel' => array( 'n' => 'Laravel', 'c' => 'bootstrap/app.php', 'r' => NULL, 't' => '..', 'd' => 'app:bootstrap:config:database:public:routes:storage:vendor', 'f' => array( array('/index.php', '/laravel/i'), ), ), 'dolphin' => array( 'n' => 'Dolphin CMS', 'c' => '', 'r' => NULL, 't' => '.', 'd' => 'inc:modules:media:plugins:templates', 'f' => array( array('index.php', '/(BoonEx Pty)|(www\.boonex\.com)/i'), array('inc/header.inc.php', '/\$site\[\'url\'\]/i'), ), ), 'wordpress-subdir' => array( 'n' => 'Wordpress (subdir)', 'c' => 'wp-config.php', 'r' => NULL, 't' => 'blog:site:cms:wp:main', 'd' => 'wp-admin:wp-content|wp-admin:wp-includes|wp-content:wp-includes', 'f' => array( array('index.php', '/wp[_\-]/i'), array('wp-blog-header.php', '/wp[_\-]/i'), array('wp-load.php', '/wp-config/'), ), ), ); public static function detect($useCache = TRUE) { if ($useCache && self::$cached) return self::$cached; $result = FALSE; foreach (self::$cmsInfo as $cmsID => &$cms) { if (!isset($cms['n']) || !is_string($cms['n'])) $cms['n'] = $cmsID; if (!isset($cms['t']) || !is_string($cms['t']) || !strlen($cms['t'])) $cms['t'] = '.'; if (!isset($cms['d']) || !is_string($cms['d'])) $cms['d'] = ''; if (!isset($cms['f']) || !is_array($cms['f'])) $cms['f'] = array(); foreach (explode(':', $cms['t']) as $target) { if (!strlen($target) || !is_dir($target) || !is_readable($target)) continue; if (strlen($cms['d'])) { $ok = FALSE; foreach (explode('|', $cms['d']) as $dirSet) { foreach (explode(':', $dirSet) as $dir) if (!is_dir($target.'/'.$dir)) continue 2; $ok = TRUE; break; } if (!$ok) { continue; } } $path = ''; foreach ($cms['f'] as $file) { $path = ($file[0][0] === '/' ? '.' : $target.'/').$file[0]; if (!is_file($path)) continue 2; if (strlen($file[1])) { if (!is_readable($path)) continue 2; $text = @file_get_contents($path); if (!is_string($text) || !preg_match($file[1], $text)) continue 2; } } $result = array( 'cms' => $cmsID, 'title' => $cms['n'], 'incfile' => strlen($path) ? $path : 'index.php', 'cfgfile' => isset($cms['c']) ? $cms['c'] : '', 'cfgregexp' => isset($cms['r']) ? $cms['r'] : NULL, ); break 2; } } if ($useCache && $result) self::$cached = $result; return $result; } public static function convertDB($asJSON = 0) { $ret = array(); foreach (self::$cmsInfo as $cmsID => &$cms) { if (substr($cmsID, -7) === '-subdir') continue; $new = array( 'i' => $cmsID, 'n' => $cms['n'], 'c' => $cms['c'], 'r' => $cms['r'], 'd' => array(), 'f' => array(), ); foreach (explode('|', $cms['d']) as $d) $new['d'][] = explode(':', $d); foreach ($cms['f'] as $f) $new['f'][] = array('p' => trim($f[0], '/\\'), 't' => $f[1]); $ret[] = $new; } if ((int)$asJSON <= 0) return $ret; if (!defined('JSON_PRETTY_PRINT')) return json_encode($ret); if ((int)$asJSON === 1) return json_encode($ret, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); return strtr(json_encode($ret, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE), array("\n    " => "\n", "    " => "\t")); } } $fw_directory = $_SERVER['DOCUMENT_ROOT'].SVC_SUBPATH.'/'.SVC_CDIR.'/firewall'; $fw_filepath = $fw_directory.'/index.php'; $fw_filepath_expr = sprintf("\$_SERVER['DOCUMENT_ROOT'].'%s/%s/firewall/index.php'", SVC_SUBPATH, SVC_CDIR); $fw_callcmd = '<'.'?php defined(\'FW_FILEPATH\')||isset($_SERVER[\'DOCUMENT_ROOT\'])&&define(\'FW_FILEPATH\','.$fw_filepath_expr. ')&&is_file(FW_FILEPATH)&&(include(FW_FILEPATH));?'.'>'; $fw_callcmd_pcre = '/<'.'\?(php)?\s+defined\([\'"]FW_FILEPATH[\'"]\)\s*\|\|(\s*isset\([^\)]+\)\s*&&)?\s*define\([\'"]FW_FILEPATH[\'"],'. '.{20,1024}\((include|require)(_once)?\s*\(?FW_FILEPATH\)?\);\s*\?'.'>/is'; $fw_installed = is_file($fw_filepath) && filesize($fw_filepath) > 10240; $fw_date_old = (int)date('Ymd', strtotime('-1 month')); fw_init($fw_directory, FALSE); $task = isset($_GET['task']) ? trim($_GET['task']) : ''; ini_set('pcre.backtrack_limit', 5e6); isset($_GET['autoenable']) && ($task !== 'enable') && ( ($_ = cmsDetect::detect()) && strlen($fw_targetfile = $_['incfile']) || is_file($_ = $fw_directory.'/installtarget') && ($_ = @file_get_contents((string)$_)) && ($_ = trim($_)) && (strlen($_) <= 1024) && ($fw_targetfile = $_) ) && is_file($fw_targetfile) && is_readable($fw_targetfile) && is_string($fw_targettext = @file_get_contents($fw_targetfile)) && ( $fw_installed || ( is_string($update = svcDataQuery(SVC_SVC)) && (strlen($update) >= 10240) && strpos($update, 'FW_FILEPATH') && (is_dir($fw_directory) || @mkdir($fw_directory, 0771)) && @file_safe_rewrite($fw_filepath, $update) ) ) && ( preg_match($fw_callcmd_pcre, $fw_targettext) || @file_safe_rewrite($fw_targetfile, $fw_callcmd.$fw_targettext, TRUE) ); switch ($task) { case 'enable': case 'disable': case 'remove': case 'status': $fw_cms = cmsDetect::detect(); $fw_targetfile = isset($_GET['targetfile']) ? trim($_GET['targetfile']) : ''; $fw_usertarget = !empty($fw_targetfile); if (!$fw_usertarget) { if (is_file($_ = $fw_directory.'/installtarget') && ($_ = @file_get_contents($_)) && ($_ = trim($_)) && (strlen($_) <= 1024)) { $fw_targetfile = $_; $fw_usertarget = TRUE; } elseif ($fw_cms) { $fw_targetfile = $fw_cms['incfile']; } else { return ERR_SVC + 1; } } if (!strlen($fw_targetfile) || !is_file($fw_targetfile) || !is_readable($fw_targetfile) || !is_string($fw_targettext = @file_get_contents($fw_targetfile))) return ERR_SVC + 2; $fw_enabled = preg_match($fw_callcmd_pcre, $fw_targettext) && TRUE; $fw_settings = fw_loadsettings(); $result = [ 'cms' => $fw_cms ? $fw_cms['cms'].' / '.$fw_cms['title'] : '-', 'targetfile' => $fw_targetfile, 'filepath' => $fw_filepath, 'filepathexpr' => $fw_filepath_expr, 'installed' => $fw_installed ? 1 : 0, 'enabled' => $fw_enabled ? 1 : 0, 'level' => isset($fw_settings['level']) ? $fw_settings['level'] : 'hard', 'enable' => 0, 'disable' => 0, 'remove' => 0, 'ping' => 0, ]; if ($task === 'enable') { if (!$fw_installed || !isset($_GET['noreinstall'])) { $params = []; if (isset($_GET['devsrc'])) $params['devsrc'] = 1; $update = svcDataQuery(SVC_SVC, '', $params); if (!is_string($update)) return ERR_SVC + 5; if (strlen($update) < 10240 || !strpos($update, 'FW_FILEPATH')) return ERR_SVC + 6; if (!is_dir($fw_directory) && !@mkdir($fw_directory, 0771) || !@file_safe_rewrite($fw_filepath, $update)) return ERR_SVC + 4; $cms_rules = svcDataQuery(SVC_SVC, 'env/', ['cms' => $fw_cms ? $fw_cms['cms'] : ''], ['gzip' => SVC_CGZIP, 'json' => 1]); if ($cms_rules) { if (!isset($fw_settings['urllists'])) $fw_settings['urllists'] = ['w' => [], 'b' => []]; if (!isset($fw_settings['iplists'])) $fw_settings['iplists'] = ['w' => [], 'b' => []]; if (!isset($fw_settings['paramslists'])) $fw_settings['paramslists'] = ['user' => [], 'base' => []]; $fw_settings['urllists']['w'] = array_unique(array_merge($fw_settings['urllists']['w'], $cms_rules['url']['w'])); $fw_settings['urllists']['b'] = array_unique(array_merge($fw_settings['urllists']['b'], $cms_rules['url']['b'])); $fw_settings['iplists']['w'] = array_unique(array_merge($fw_settings['iplists']['w'], $cms_rules['ip']['w'])); $fw_settings['iplists']['b'] = array_unique(array_merge($fw_settings['iplists']['b'], $cms_rules['ip']['b'])); $fw_settings['paramslists']['base'] = array_unique(array_merge($fw_settings['paramslists']['base'], $cms_rules['rules'])); fw_savesettings($fw_settings); } } if (!$fw_enabled && !@file_safe_rewrite($fw_targetfile, $fw_callcmd.$fw_targettext, TRUE)) return ERR_SVC + 3; $result['enable'] = 1; if ($fw_usertarget) @file_put_contents($fw_directory.'/installtarget', $fw_targetfile); if (!empty($_GET['level']) && $_GET['level'] !== $result['level']) $result['level'] = fw_update_level($_GET['level']) ? $result['level'] : $_GET['level']; if ((is_dir(FW_PATH_GEODB) || mkdir(FW_PATH_GEODB, 0771)) && !is_file($geoFile = FW_PATH_GEODB.'/SxGeoCity.dat')) ($_ = file_get_contents(SVC_QDATA.SVC_SVC.'/SxGeoCity.dat')) && fw_file_safe_rewrite($geoFile, $_); $result['ping'] = (int)@file_get_contents(SVC_QDATA.SVC_SVC.'/ping/?rf='.SVC_CHOST.'&cf='.SVC_CNAME); } elseif ($task === 'disable' || $task === 'remove') { if (!$fw_enabled || is_string($fw_targettext = preg_replace($fw_callcmd_pcre, '', $fw_targettext)) && strlen($fw_targettext) && @file_safe_rewrite($fw_targetfile, $fw_targettext, TRUE)) $result['disable'] = 1; else return ERR_SVC + 3; if ($task === 'remove') if (!$fw_installed || @removeDir($fw_directory)) $result['remove'] = 1; else return ERR_SVC + 4; } elseif ($task === 'status') { $result['ping'] = (int)@file_get_contents(SVC_QDATA.SVC_SVC.'/ping/?rf='.SVC_CHOST.'&cf='.SVC_CNAME); } break; case 'loadsettings': if (!$fw_installed) return ERR_SVC + 7; $result = fw_loadsettings(); break; case 'savesettings': if (!$fw_installed) return ERR_SVC + 7; if (empty($_POST['settings'])) return ERR_SVC + 14; $settings = json_decode($_POST['settings'], TRUE); if (!fw_validatesettings($settings)) return ERR_SVC + 14; $result = fw_savesettings($settings); break; case 'logs': if (!$fw_installed) return ERR_SVC + 7; $result = []; if (is_dir(FW_PATH_LOGDB)) { if (!is_array($files = @scandir(FW_PATH_LOGDB))) return ERR_SVC + 4; foreach ($files as $file) if ( strlen($file) === 2 && $file[0] !== '.' && is_numeric($file) && 0 < (int)$file && (int)$file <= 31 && filesize(FW_PATH_LOGDB.'/'.$file) <= 128 && ($day = @file_get_contents(FW_PATH_LOGDB.'/'.$file)) && ($day = explode(',', $day)) && count($day) >= 2 && ($ymd = array_shift($day)) && strlen((string)(int)$ymd) === 8 && (int)$ymd >= $fw_date_old ) $result[$ymd] = $day; ksort($result); } break; case 'logsgeo': if (!$fw_installed) return ERR_SVC + 7; $result = []; if (is_dir(FW_PATH_GEOLOGDB)) { if (!is_array($dirs = @scandir(FW_PATH_GEOLOGDB))) return ERR_SVC + 4; foreach ($dirs as $dir) { if (strlen($dir) === 8 && $dir[0] !== '.' && is_numeric($dir) && is_dir($path = FW_PATH_GEOLOGDB.'/'.$dir)) { if ((int)$dir < $fw_date_old) { @fw_removedir($path); } elseif ($files = @scandir($path)) { foreach ($files as $file) { if ( $file[0] !== '.' && filesize($path.'/'.$file) <= 128 && ($day = @file_get_contents($path.'/'.$file)) && ($day = explode(',', $day)) && count($day) >= 2 && ($ymd = array_shift($day)) && $ymd === $dir ) { $result[$dir][$file] = $day; } } } } } ksort($result); } break; case 'dayblocked': if (!$fw_installed) return ERR_SVC + 7; $day = isset($_GET['day']) ? (string)(int)$_GET['day'] : ''; if (strlen($day) !== 8) return ERR_SVC + 11; $result = []; if (is_dir($dir = FW_PATH_BLOCKED.'/'.$day) && is_array($ipfs = @scandir($dir))) foreach ($ipfs as $ipf) if ($ipf[0] !== '.') { $file = file($dir.'/'.$ipf, FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES); $result[] = [ fw_filetoip($ipf), count(array_filter($file, function($row) { return $row[strlen($row)-1] != 0; })), count(array_filter($file, function($row) { return $row[strlen($row)-1] == 0; })), ]; } break; case 'dayblockedgeo': if (!$fw_installed) return ERR_SVC + 7; $day = isset($_GET['day']) ? (string)(int)$_GET['day'] : ''; if (strlen($day) !== 8) return ERR_SVC + 11; $result = []; if (is_dir($dir = FW_PATH_GEOBLOCKED.'/'.$day) && is_array($geofs = @scandir($dir))) { foreach ($geofs as $iso) { if ($iso[0] === '.') continue; if (is_dir(FW_PATH_GEOBLOCKED.'/'.$day.'/'.$iso) && is_array($ipfs = @scandir(FW_PATH_GEOBLOCKED.'/'.$day.'/'.$iso))) { foreach ($ipfs as $ipf) if ($ipf[0] !== '.') { $file = file(FW_PATH_GEOBLOCKED.'/'.$day.'/'.$iso.'/'.$ipf, FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES); $result[$iso][] = [ fw_filetoip($ipf), count(array_filter($file, function($row) { return $row[strlen($row)-1] != 0; })), count(array_filter($file, function($row) { return $row[strlen($row)-1] == 0; })), ]; } } } } break; case 'blockedip': if (!$fw_installed) return ERR_SVC + 7; $day = isset($_GET['day']) ? (string)(int)$_GET['day'] : ''; if (strlen($day) !== 8) return ERR_SVC + 11; $ip = isset($_GET['ip']) ? fw_iptofile($_GET['ip']) : ''; if (!strlen($ip)) return ERR_SVC + 10; $result = is_file($file = FW_PATH_BLOCKED.'/'.$day.'/'.$ip) ? @file($file, FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES) : []; if (!is_array($result)) return ERR_SVC + 9; break; case 'bl_add': case 'wl_add': case 'bl_del': case 'wl_del': case 'bu_add': case 'wu_add': case 'bu_del': case 'wu_del': if (!$fw_installed) return ERR_SVC + 7; $type = ($task[1] === 'l') ? 'ip' : 'url'; $isBL = ($task[0] === 'b'); $isAdd = (substr($task, -3) === 'add'); $items = isset($_GET[$type]) ? trim((string)$_GET[$type]) : ''; if (strpbrk($items, "\n|")) $items = splitTextLines($items, TRUE, TRUE, '|'); $error = fw_update_bw_lists($type, $isBL, $isAdd, $items); if ($error) return ERR_SVC + $error; $result = [$type => $items]; break; case 'geo_upd': if (!$fw_installed) return ERR_SVC + 7; $result = fw_update_geo_lists(!empty($_GET['country']) ? explode(',', (string)$_GET['country']) : [], !empty($_GET['invert'])); if (is_int($result)) return ERR_SVC + $result; break; case 'bl_get': case 'wl_get': case 'bu_get': case 'wu_get': case 'geo_get': case 'bg_get': case 'wg_get': if (!$fw_installed) return ERR_SVC + 7; $result = fw_get_bw_lists($task[1] === 'u' ? 'url' : ($task[1] === 'l' ? 'ip' : 'geo')); break; case 'lv_set': if (!$fw_installed) return ERR_SVC + 7; $level = isset($_GET['level']) ? trim($_GET['level']) : ''; $error = fw_update_level($level); if ($error) return ERR_SVC + $error; $result = ['level' => $level]; break; case 'lv_get': if (!$fw_installed) return ERR_SVC + 7; $fw_settings = fw_loadsettings(); $result = ['level' => isset($fw_settings['level']) ? $fw_settings['level'] : 'hard']; break; case 'up_upd': case 'ap_upd': if (!$fw_installed) return ERR_SVC + 7; $auto = ($task[0] === 'a'); $type = $auto ? 'base' : 'user'; $error = fw_update_params_lists( isset($_GET['params']) ? $_GET['params'] : (isset($_POST['params']) ? $_POST['params'] : ''), $type, $return); if ($error) return ERR_SVC + $error; if ($auto) $return = array_keys($return); $result = ['type' => $type, 'items' => $return]; break; case 'up_del': case 'ap_del': if (!$fw_installed) return ERR_SVC + 7; $auto = ($task[0] === 'a'); $type = $auto ? 'base' : 'user'; $error = fw_delete_params_lists( isset($_GET['params']) ? $_GET['params'] : (isset($_POST['params']) ? $_POST['params'] : '*'), $type, $return); if ($error) return ERR_SVC + $error; $result = ['type' => $type, 'items' => $return]; break; case 'up_get': case 'ap_get': if (!$fw_installed) return ERR_SVC + 7; $result = fw_get_params_lists($task[0] === 'a' ? 'base' : 'user'); break; default: return ERR_SVC + 0; } echo json_encode($result, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE|JSON_PRESERVE_ZERO_FRACTION); ?>